<?php
/*-----------------------------------
		Header Style  
------------------------------------*/
CSF::createSection($prefix, array(
    'parent' => 'header_options',
    'title'  => esc_html__('Header Options', 'vernex-core'),
    'id'     => 'theme_header_style_main',
    'icon'   => 'fab fa-algolia',
    'fields' => array(
        array(
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__('Select Header Style', 'vernex-core') . '</h3>'
        ),
        array(
            'id'      => 'header_menu_style',
            'title'   => esc_html__('Select Style', 'vernex-core'),
            'type'    => 'image_select',
            'options' => array(
                'header_one'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-1.png'),
                'header_two'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-2.png'),
                'header_three' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-3.png'),
                'header_four'  => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-4.png'),
                'header_five'  => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-5.png'),
                'header_six'   => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-6.png'),
            ),
            'default' => 'header_one',
            'desc'    => wp_kses(__('You <mark>selected</mark> this header and the content below.', 'vernex-core'), wp_kses_allowed_html('post')),
        ),

        /*************** Header one content ***************/
        array(
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__('Header Content', 'vernex-core') . '</h3>'
        ),

        array(
            'id'        => 'header_menu_bar_text',
            'type'      => 'text',
            'title'     => esc_html__('Menu Label', 'nexaq-core'),
            'default'   => esc_html__('Menu Bar', 'nexaq-core'),
            'dependency' => array(
                array( 'header_menu_style', 'any', 'header_three,header_four,' ),
              ),
        ),

        array(
            'id'      => 'header_one_button_enable',
            'title'   => esc_html__('Enable Button ', 'vernex-core'),
            'type'    => 'switcher',
            'desc'    => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Button Options', 'vernex-core'),  wp_kses_allowed_html('post')),
            'default' => true,
        ),

        array(
            'id'         => 'header_one_button_label',
            'type'       => 'text',
            'title'      => esc_html__('Button Label', 'vernex-core'),
            'default'    => esc_html__('Start A Project', 'vernex-core'),
            'dependency' => array(
                array('header_one_button_enable', '==', 'true'),
            ),
        ),
        array(
            'id'      => 'header_one_button_link',
            'type'    => 'link',
            'title'   => esc_html__('Button Link', 'vernex-core'),
            'default' => array(
                'url'    => '#',
                'target' => '_blank'
            ),
            'desc'       => wp_kses(__('add your <mark>Button Link</mark> here', 'vernex-core'),  wp_kses_allowed_html('post')),
            'dependency' => array(
                array('header_one_button_enable', '==', 'true'),
            ),
        ),

        array(
            'id'         => 'header_one_sidebar_button_label',
            'type'       => 'text',
            'title'      => esc_html__('Sidebar Button Label', 'nexaq-core'),
            'default'    => esc_html__('GET IN TOUCH', 'nexaq-core'),
            'dependency' => array(
                array( 'header_menu_style', 'any', 'header_one,header_two,header_five' ),
              ),
        ),
 
        array(
            'id'      => 'contact_type_header',
            'type'    => 'radio',
            'title'   => esc_html__('Contact Type', 'vernex-core'),
            'options' => array(
                'phone'  => esc_html('Phone'),
                'email'  => esc_html('Email'),
                'others' => esc_html('Others'),
            ),
            'default' => 'phone',
          'dependency' => array( 'header_menu_style', 'any', 'header_three,header_four' ),
        ),

        array(
            'id'      => 'contact_type_header_phone_icon',
            'type'    => 'media',
            'title'   => esc_html__('Icon (SVG)', 'vernex-core'),
            'default' => array(
                'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/phone-icon.svg'),
                'id'        => 'contact_icon',
                'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/phone-icon.svg'),
                'alt'       => esc_attr('content-icons'),
                'title'     => esc_html('Icon'),
            ),
            'dependency' => array(
                array( 'contact_type_header', '==', 'phone' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_phone_content_title',
            'type'       => 'text',
            'title'      => esc_html__('Content Title', 'vernex-core'),
            'default'    => esc_html__('Any Question', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'phone' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_info',
            'type'       => 'text',
            'default'    => esc_html__('+91 656 786 53', 'vernex-core'),
            'title'      => esc_html__('Contact Information', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'phone' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'      => 'contact_type_header_email_icon',
            'type'    => 'media',
            'title'   => esc_html__('Icon (SVG)', 'vernex-core'),
            'default' => array(
                'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/email.svg'),
                'id'        => 'email_icon',
                'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES  . '/topbar/email.svg'),
                'alt'       => esc_attr('content-icons'),
                'title'     => esc_html('Icon'),
            ),
            'dependency' => array(
                array( 'contact_type_header', '==', 'email' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_email_content_title',
            'type'       => 'text',
            'title'      => esc_html__('Content Title', 'vernex-core'),
            'default'    => esc_html__('Any Question', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'email' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_info_text',
            'type'       => 'text',
            'default'    => esc_html__('info@example.com', 'vernex-core'),
            'title'      => esc_html__('Contact Information', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'email' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_custom_icon',
            'type'       => 'media',
            'title'      => esc_html__('Icon (SVG)', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'others' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_custom_content_title',
            'type'       => 'text',
            'title'      => esc_html__('Custom Title', 'vernex-core'),
            'default'    => esc_html__('Any Question', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'others' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'         => 'contact_type_header_custom_text',
            'type'       => 'text',
            'title'      => esc_html__('Custom Text', 'vernex-core'),
            'dependency' => array(
                array( 'contact_type_header', '==', 'others' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),

        array(
            'id'      => 'contact_type_header_custom_link',
            'type'    => 'link',
            'title'   => esc_html__('Custom Link', 'vernex-core'),
            'default' => array(
                'url'    => '#',
                'target' => '_blank'
            ),
            'dependency' => array(
                array( 'contact_type_header', '==', 'others' ),
                array( 'header_menu_style', 'any', 'header_three,header_four' ),
              ),
        ),
    ),
));
