<?php
/*-------------------------------------------------------
		  ** General Options
	--------------------------------------------------------*/

CSF::createSection($prefix, array(
  'title'  => esc_html__('General', 'vernex-core'),
  'id'     => 'theme_header_options',
  'icon'   => 'fa fa-cog',
  'fields' => array(
    array(
      'type'    => 'subheading',
      'content' => '<h3>' . esc_html__('General Options ', 'vernex-core') . '</h3>',
    ),
    array(
      'id'      => 'primary_theme_color',
      'type'    => 'color_group',
      'title'   => esc_html__('Primary Color', 'vernex-core'),
      'options' => array(
        'primary_color'     => esc_html__('Main Color', 'vernex-core'),
        'primary_color_opc' => esc_html__('Opacity Color', 'vernex-core'),
      ),
      'desc' => wp_kses(__("Choose the <mark>primary and opacity color</mark> for your website's theme.", 'vernex-core'), wp_kses_allowed_html('post')),
    ),

    array(
      'id'             => 'primary_font',
      'type'           => 'typography',
      'title'          => esc_html__('Primary Font Kanit', 'vernex-core'),
      'color'          => false,
      'font_size'      => false,
      'text_align'     => false,
      'font_style'     => false,
      'line_height'    => false,
      'letter_spacing' => false,
      'text_transform' => false,
      'desc' => wp_kses(__("Choose the <mark>primary Font</mark> for your website's body & all over the theme.", 'vernex-core'), wp_kses_allowed_html('post')),
    ),

    array(
      'id'             => 'secondary_font',
      'type'           => 'typography',
      'title'          => esc_html__('Secondary Font Inter', 'vernex-core'),
      'color'          => false,
      'font_size'      => false,
      'text_align'     => false,
      'font_style'     => false,
      'line_height'    => false,
      'letter_spacing' => false,
      'text_transform' => false,
      'desc' => wp_kses(__("Choose the <mark>Secondary Font</mark> for your website's some place use in this theme.", 'vernex-core'), wp_kses_allowed_html('post')),
    ),

    array(
      'id'      => 'header_logo',
      'title'   => esc_html__('Upload Header Logo', 'vernex-core'),
      'type'    => 'media',
      'desc'    => wp_kses(__('you can upload <mark>Header Logo</mark> for header', 'vernex-core'), wp_kses_allowed_html('post')),
      'default' => array(
        'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/logo/logo.svg'),
        'id'        => 'logo1',
        'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/logo/logo.svg'),
        'alt'       => esc_attr('logo-dark'),
        'title'     => esc_html('Logo'),
      ),
    ),

    array(
      'id'      => 'header_mobile_logo',
      'title'   => esc_html__('Upload Header Mobile Logo', 'vernex-core'),
      'type'    => 'media',
      'desc'    => wp_kses(__('you can upload <mark>Header Mobile Logo</mark> for header', 'vernex-core'), wp_kses_allowed_html('post')),
      'default' => array(
        'url'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/logo/logo.svg'),
        'id'        => 'logo1',
        'thumbnail' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/logo/logo.svg'),
        'alt'       => esc_attr('logo-mobile'),
        'title'     => esc_html('Logo'),
      ),
    ),

    array(
      'id'               => 'header_logo_dimensions',
      'type'             => 'dimensions',
      'title'            => 'Set Header Logo width & height',
      'output_important' => true,
      'default'          => array(
        'width'  => '150',
        'height' => '',
        'unit'   => 'px',
      ),
      'output' => array(
        '.header-area .header-logo a img',
      ),
    ),

  ),


));
