<?php

/*-----------------------------------
PAGE MENU SECTION
------------------------------------*/
CSF::createSection(
    $prefix,
    array(
        'title'  => esc_html__('Page Header', 'vernex-core'),
        'parent' => 'page_meta_option',
        'fields' => array(

            //Page Header Options
            array(
                'type'    => 'subheading',
                'content' => esc_html__('Header Options', 'vernex-core'),
            ),

            array(
                'id'      => 'page_header_menu_style',
                'title'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => 'image_select',
                'options' => array(
                    'select_themeOption' => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/default.png'),
                    'header_one'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-1.png'),
                    'header_two'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-2.png'),
                    'header_three'       => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-3.png'),
                    'header_four'        => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-4.png'),
                    'header_five'        => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-5.png'),
                    'header_six'         => esc_url(EGNS_CORE_THEME_OPTIONS_IMAGES . '/header/header-6.png'),
                ),
                'default' => 'select_themeOption',
                'desc'    => wp_kses(__('You <mark>selected</mark> this header and the content below.', 'vernex-core'), wp_kses_allowed_html('post')),
            ),
            array(
                'id'      => 'page_main_header_enable',
                'type'    => 'select',
                'title'   => esc_html__('Main Header', 'vernex-core'),
                'desc'    => wp_kses(__('you can enable/disable <mark>Main Header </mark> for header section', 'vernex-core'), wp_kses_allowed_html('post')),
                'options' => array(
                    'enable'  => esc_html('Enable'),
                    'disable' => esc_html('Disable'),
                ),
                'default' => 1
            ),
            array(
                'type'       => 'subheading',
                'content'    => '<h3>' . esc_html__('Upload Logo', 'vernex-core') . '</h3>',
                'dependency' => array(
                    array('page_header_menu_style', '!=', 'select_themeOption'),   // Ensure it's not the default option
                ),
            ),
            array(
                'id'         => 'page_header_logo',
                'title'      => esc_html__('Upload Header Logo', 'vernex-core'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Header light Logo</mark> for header', 'vernex-core'), wp_kses_allowed_html('post')),
                'dependency' => array(
                    array('page_header_menu_style', '!=', 'select_themeOption'),   // Ensure it's not the default option
                ),
            ),

            array(
                'id'         => 'page_header_mobile_logo',
                'title'      => esc_html__('Upload Header Mobile Logo', 'vernex-core'),
                'type'       => 'media',
                'desc'       => wp_kses(__('you can upload <mark>Header mobile Logo</mark> for header', 'vernex-core'), wp_kses_allowed_html('post')),
                'dependency' => array(
                    array('page_header_menu_style', '!=', 'select_themeOption'),   // Ensure it's not the default option
                ),
            ),

        ),
    )
);
