<?php
/*-----------------------------------
    PAGE BARNER SECTION
------------------------------------*/

CSF::createSection(
	$prefix,
	array(
		'title'  => esc_html__('Breadcrumb', 'vernex-core'),
		'parent' => 'page_meta_option',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__('Breadcrumb Options', 'vernex-core'),
			),

			array(
				'id'      => 'enable_breadcrumb',
				'type'    => 'switcher',
				'title'   => esc_html__('Enable Breadcrumb', 'vernex-core'),
				'desc'    => esc_html__('If you want to show or hide page banner you can set here by toggle ( YES / NO ).', 'vernex-core'),
				'default' => true,
			),

			array(
				'id'         => 'page_breadcrumb_subtitle_text',
				'type'       => 'text',
				'title'      => esc_html__('Breadcrumb Subtitle', 'vernex-core'),
			),

			array(
				'id'    => 'breadcrumb_page_bg_color',
				'type'  => 'color',
				'title' => esc_html__('Breadcrumb Background Color', 'vernex-core'),
			),

			array(
				'id'         => 'breadcrumb_page_bg_image',
				'type'       => 'media',
				'title'      => esc_html__('Breadcrumb Background Image', 'vernex-core'),
				'desc'       => esc_html__('Set the banner background image', 'vernex-core'),
				'dependency' => array('enable_breadcrumb', '==', 'true'),
			),
		)
	)
);
