<?php
// exit if access directly
if (!defined('ABSPATH')) {
    exit();
}
function egnsCustomStyling()
{

    $custom_css         = "";
    $egns_theme_options = get_option('egns_theme_options');
    $egns_page_options  = get_post_meta(get_the_ID(), 'egns_page_options', true);

    /**************************
     * Primary Color Start
     *************************/

    $primary_main_color = $egns_theme_options['primary_theme_color']['primary_color'] ?? '';
    $primary_opc_color  = $egns_theme_options['primary_theme_color']['primary_color_opc'] ?? '';

    // Get hex color 
    $hex = $primary_opc_color;

    // Remove the '#' if present
    $hex = ltrim($hex, '#');

    // Convert the hex to RGB values
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));


    if (!empty($primary_main_color)) {
        $custom_css .= "
        :root{
                --primary-color : $primary_main_color !important;
                --primary-color2: $primary_main_color !important;
             }
         ";
    }

    if (!empty($primary_opc_color)) {
        $custom_css .= "
        :root{
                --primary-color-opc : $r, $g, $b !important;
                --primary-color2-opc: $r, $g, $b !important;
             }
         ";
    }

    /**************************
     * Primary Color End
     *************************/




    /**************************
     * Primary Font Start
     *************************/
    $primary_font = $egns_theme_options['primary_font']['font-family'] ?? '';

    if (!empty($primary_font)) {
        $custom_css .= "
         :root{
                 --font-kanit: '$primary_font', sans-serif !important;
              }
          ";
    }

    $secondary_font = $egns_theme_options['secondary_font']['font-family'] ?? '';

    if (!empty($secondary_font)) {
        $custom_css .= "
         :root{
                 --font-inter: '$secondary_font', sans-serif !important;
              }
          ";
    }

    /**************************
     * Primary Font End
     *************************/



    /************************
     * Start Breadcrumb Style
     ************************/

    //Breadcrumb BG Color
    $breadcump_normal_color_background = $egns_theme_options['breadcrumb_background_color'] ?? '';
    $breadcump_page_color_background   = $egns_page_options['breadcrumb_page_bg_color'] ?? '';

    if (!empty($breadcump_page_color_background)) {
        $custom_css .= "
        .breadcrumb-section {
            background-color: $breadcump_page_color_background !important;
        }
    ";
    } else {
        if (!empty($breadcump_normal_color_background)) {
            $custom_css .= "
            .breadcrumb-section {
                background-color: $breadcump_normal_color_background !important;
            }
        ";
        }
    }

    //Breadcrumb BG
    $breadcump_background      = $egns_theme_options['breadcrumb_bg_image']['url'] ?? '';
    $breadcump_page_background = $egns_page_options['breadcrumb_page_bg_image']['url'] ?? '';

    if (!empty($breadcump_page_background)) {
        $custom_css .= "
    .breadcrumb-section{
        background-image: linear-gradient(91.45deg, #000000 17.96%, rgba(0, 0, 0, 0.9) 44.49%, rgba(0, 0, 0, 0.8) 67.58%, rgba(0, 0, 0, 0.5) 98.52%),url($breadcump_page_background) !important;
    }
    ";
    } else {
        if (!empty($breadcump_background)) {
            $custom_css .= "
        .breadcrumb-section{
            background-image: linear-gradient(91.45deg, #000000 17.96%, rgba(0, 0, 0, 0.9) 44.49%, rgba(0, 0, 0, 0.8) 67.58%, rgba(0, 0, 0, 0.5) 98.52%),url($breadcump_background) !important;
        }
    ";
        }
    }


    /*********************
     * End Breadcrumb
     *********************/



    /*********************
     * Footer Style
     *********************/

    /*********************
     * End Footer Style
     *********************/



    /*********************
     * Other's Style
     *********************/
    $button = Egns\Helper\Egns_Helper::egns_get_theme_option('header_one_button_enable') == 1 ?? '';

    if (empty($button)) {
        $custom_css .= "
        header.style-1 .nav-right .right-sidebar-button::after,
        header.style-2 .nav-right .right-sidebar-button::after,
        header.style-3 .nav-right::before {
            display: none !important;
        }
        ";
    }
    /*********************
     * End Other's Style
     *********************/







    wp_register_style('egns-stylesheet', false);
    wp_enqueue_style('egns-stylesheet', false);
    wp_add_inline_style('egns-stylesheet', $custom_css, true);
}
if (class_exists('CSF')) {
    add_action('wp_enqueue_scripts', 'egnsCustomStyling');
}
