<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Sketch_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_sketch';
    }

    public function get_title()
    {
        return esc_html__('EG Sketch', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'vernex_sketch_content_section',
            [
                'label' => esc_html__('General', 'vernex-core'),
            ]
        );

        // Title
        $this->add_control(
            'sketch_section_title',
            [
                'label'         => esc_html__('Section Title', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => esc_html__('Sketch to real home transfer your hand', 'vernex-core'),
                'label_block'   => true
            ]
        );

        //Background Image
        $this->add_control(
            'sketch_section_bg_image',
            [
                'label'         => esc_html('Background Image', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::MEDIA,
                'media_types'   => ['image', 'svg'],
                'default'       => [
                    'url'       => \Elementor\Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $sketch_rooms = new \Elementor\Repeater();

        $sketch_rooms->add_control(
            'room_title',
            [
                'label'         => esc_html__('Room Title', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => esc_html__('Bed Room', 'vernex-core'),
                'label_block'   => true,
            ]
        );

        $sketch_rooms->add_control(
            'room_image_url',
            [
                'label'         => esc_html__('Image', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::MEDIA,
                'default'       => [
                    'url'       => \Elementor\Utils::get_placeholder_image_src()
                ],
            ]
        );

        $this->add_control(
            'sketch_rooms',
            [
                'label' => esc_html__('Add Room Images', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $sketch_rooms->get_controls(),
                'default' => [
                    [
                        'room_title' => esc_html__('Bed Room', 'vernex-core'),
                    ],
                    [
                        'room_title' => esc_html__('Guest Room', 'vernex-core'),
                    ]
                ],
                'title_field'   => '{{{ room_title }}}'
            ]
        );


        $this->end_controls_section();

        //Start Control Section
        $this->start_controls_section(
            'vernex_sketch_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_sketch_general_section_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_sketch_general_section_title_typ',
                'selector' => '{{WRAPPER}} .home6-sketch-section .title-area h2',

            ]
        );

        $this->add_control(
            'vernex_sketch_general_section_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-sketch-section .title-area h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_sketch_room_name',
            [
                'label'     => esc_html__('Room Name', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_sketch_room_name_typ',
                'selector' => '{{WRAPPER}} .home6-sketch-section .home6-sketch-bg .indicator-area ul li .single-item span',

            ]
        );

        $this->add_control(
            'vernex_sketch_room_name_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-sketch-section .home6-sketch-bg .indicator-area ul li .single-item span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'name'      => 'vernex_projects_tab_image_title_bg',
                'selector' => '{{WRAPPER}} .home6-sketch-section .home6-sketch-bg .indicator-area ul li .single-item span',
            ]
        );
        $this->end_controls_section();
    }



    // Frontend Output 
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $sketch_images = $settings['sketch_rooms'];
?>


        <div class="home6-sketch-section">
            <div class="title-area wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                <h2><?php echo esc_html($settings['sketch_section_title']); ?></h2>
                <img src="<?php echo esc_url($settings['sketch_section_bg_image']['url']); ?>" alt="<?php echo esc_attr__('image-banner','vernex-core');?>" class="vector">
            </div>
            <div class="home6-sketch-bg wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                <div class="indicator-area">
                    <ul>
                        <?php
                            foreach( $sketch_images as $image ):
                        ?>
                        <li class="active">
                            <div class="dot-main">
                                <div class="promo-video">
                                    <div class="waves-block">
                                        <div class="waves wave-1"></div>
                                        <div class="waves wave-2"></div>
                                        <div class="waves wave-3"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="single-item">
                                <?php if(!empty($image[ 'room_image_url' ]['url'])) : ?>
                                <img src="<?php echo esc_url( $image[ 'room_image_url' ]['url'] ); ?>" alt="<?php echo esc_attr__('room-image','vernex-core');?>">
                                <?php endif; ?>
                                <?php if(!empty($image['room_title'])) : ?>
                                <span><?php echo esc_html( $image['room_title'] ); ?></span>
                                <?php endif; ?>
                            </div>
                        </li>
                        <?php endforeach; ?>
                        
                    </ul>
                </div>
            </div>
        </div>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Sketch_Widget());
