<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Service_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_service';
    }

    public function get_title()
    {
        return esc_html__('EG Service', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_service_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    'style_six' => esc_html__('Style Six', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_show_pagination',
            [
                'label' => esc_html__("Show Pagination?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_five'],
                ]
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_subtitle',
            [
                'label' => esc_html__('Subtitle', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Our Construction Services'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your subtitle here', 'vernex-core'),
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_one', 'style_three', 'style_five']
                ],

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Services Tailored You.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_one', 'style_three', 'style_six']
                ],

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_s_four_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('What We <br> Work. ', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_four', 'style_five']
                ],

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_short_description',
            [
                'label' => esc_html__('Short Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('We understand your needs and delivery digitaloi marketing through unique selling oneto homeles proposition Our team of expert.
'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_one', 'style_three']
                ],
            ]
        );

        $service_one = new \Elementor\Repeater();


        $service_one->add_control(
            'vernex_service_section_genaral_service_three_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Residential <span>Construction</span>', wp_kses_allowed_html('post')),
                'label_block' => true,
            ]
        );

        $service_one->add_control(
            'vernex_service_section_genaral_service_three_title_url',
            [
                'label' => esc_html__('Title URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $service_one->add_control(
            'vernex_service_section_genaral_service_three_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default'   => esc_html__('Sed nisl eros, condimentum nec risus sit amet finibus cons sem. Fusce fringilla est libero, sed tempus urna feugiat eu.', 'vernex-core'),
                'placeholder' => esc_html__('Type Your text here', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $service_one->add_control(
            'vernex_service_section_genaral_service_three_tag_list',
            [
                'label'     => esc_html__('Tag List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses('<a href="#">Logo Design</a>
<a href="#">Brand Guidelines</a>
<a href="#">Visual Identity</a>
<a href="#">Logo Design</a>', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('Enter your text here.', 'vernex-core'),
                'label_block' => true,

            ]
        );

        $service_one->add_control(
            'vernex_service_section_genaral_service_three_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,

            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_service_three_service_list',
            [
                'label'     => esc_html__('Service List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $service_one->get_controls(),
                'default'   => [
                    [
                        'vernex_service_section_genaral_service_three_title'    => wp_kses('Residential <span>Construction</span>', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_three_description'        => __('Health and care consulting refers to the practice of providing your expert advice and guidance.', 'vernex-core'),
                    ],
                    [
                        'vernex_service_section_genaral_service_three_title'    => wp_kses('Commercial <span>Construction</span>', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_three_description'        => __('Health and care consulting refers to the practice of providing your expert advice and guidance.', 'vernex-core'),
                    ],
                    [
                        'vernex_service_section_genaral_service_three_title'    => wp_kses('Industrial  <span>Construction</span>', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_three_description'        => __('Health and care consulting refers to the practice of providing your expert advice and guidance.', 'vernex-core'),
                    ],
                ],
                'title_field'    => '{{{ vernex_service_section_genaral_service_three_title }}}',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );


        $service_two = new \Elementor\Repeater();


        $service_two->add_control(
            'vernex_service_section_genaral_service_two_thumbnail',
            [
                'label' => esc_html__('Thumbnail Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $service_two->add_control(
            'vernex_service_section_genaral_service_two_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );


        $service_two->add_control(
            'vernex_service_section_genaral_service_two_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
            ]
        );



        $service_two->add_control(
            'vernex_service_section_genaral_service_two_title_url',
            [
                'label' => esc_html__('Title URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_service_two_service_list',
            [
                'label'     => esc_html__('Service List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $service_two->get_controls(),
                'default'   => [
                    [
                        'vernex_service_section_genaral_service_two_title'    => wp_kses('Residential', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_two_title'    => wp_kses('Commercial', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_two_title'    => wp_kses('Property', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_two_title'    => wp_kses('Development', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_two_title'    => wp_kses('Relocation', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_service_section_genaral_service_two_title }}}',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_two',
                ],
            ]
        );



        $service_three = new \Elementor\Repeater();


        $service_three->add_control(
            'vernex_service_section_genaral_service_s_three_thumbnail',
            [
                'label' => esc_html__('Thumbnail Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $service_three->add_control(
            'vernex_service_section_genaral_service_s_three_number',
            [
                'label'     => esc_html__('Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('01'),
                'label_block' => true,
            ]
        );


        $service_three->add_control(
            'vernex_service_section_genaral_service_s_three_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Conceptual Design'),
                'label_block' => true,
            ]
        );

        $service_three->add_control(
            'vernex_service_section_genaral_service_s_three_title_url',
            [
                'label' => esc_html__('Title URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_service_s_three_list',
            [
                'label'     => esc_html__('Service List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $service_three->get_controls(),
                'default'   => [
                    [
                        'vernex_service_section_genaral_service_s_three_number'    => wp_kses('01.', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_s_three_title'    => wp_kses('Conceptual Design', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_s_three_number'    => wp_kses('02.', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_s_three_title'    => wp_kses('Schematic Design', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_s_three_number'    => wp_kses('03.', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_s_three_title'    => wp_kses('Interior Design', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_s_three_number'    => wp_kses('04.', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_s_three_title'    => wp_kses('Sustainable Design', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_s_three_number'    => wp_kses('05.', wp_kses_allowed_html('post')),
                        'vernex_service_section_genaral_service_s_three_title'    => wp_kses('Urban Planning', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_service_section_genaral_service_s_three_number }}}',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_three',
                ],
            ]
        );


        $service_four = new \Elementor\Repeater();


        $service_four->add_control(
            'vernex_service_section_genaral_service_four_thumbnail',
            [
                'label' => esc_html__('Thumbnail Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $service_four->add_control(
            'vernex_service_section_genaral_service_four_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
            ]
        );


        $service_four->add_control(
            'vernex_service_section_genaral_service_four_service_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html("Conduct & we thorn need effortless marketing well agency we're looking for."),
                'label_block' => true,
            ]
        );

        $service_four->add_control(
            'vernex_service_section_genaral_service_four_service_title_url',
            [
                'label' => esc_html__('Title URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $service_four->add_control(
            'vernex_service_section_genaral_service_four_service_button',
            [
                'label'     => esc_html__('Button Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Learn More'),
                'label_block' => true,
            ]
        );


        $service_four->add_control(
            'vernex_service_section_genaral_service_four_service_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_service_four_service_list',
            [
                'label'     => esc_html__('Service List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $service_four->get_controls(),
                'default'   => [
                    [
                        'vernex_service_section_genaral_service_four_service_title'    => wp_kses('Planning & Design', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_four_service_title'    => wp_kses('Kitchen Renovation', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_four_service_title'    => wp_kses('Windows & Doors', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_service_section_genaral_service_four_service_title }}}',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_four',
                ],
            ]
        );

        $service_five = new \Elementor\Repeater();

        $service_five->add_control(
            'vernex_service_section_genaral_service_five_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );


        $service_five->add_control(
            'vernex_service_section_genaral_service_five_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
            ]
        );



        $service_five->add_control(
            'vernex_service_section_genaral_service_five_title_url',
            [
                'label' => esc_html__('Title URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $service_five->add_control(
            'vernex_service_section_genaral_service_five_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Conduct a thoroug need effortless assessment the understand your current marketing.'),
                'label_block' => true,
            ]
        );

        $service_five->add_control(
            'vernex_service_section_genaral_service_five_button_text',
            [
                'label'     => esc_html__('Button Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LEARN MORE'),
                'label_block' => true,
            ]
        );

        $service_five->add_control(
            'vernex_service_section_genaral_service_five_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_service_five_list',
            [
                'label'     => esc_html__('Service List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $service_five->get_controls(),
                'default'   => [
                    [
                        'vernex_service_section_genaral_service_five_title'    => wp_kses('Residential', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_five_title'    => wp_kses('Commercial', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_five_title'    => wp_kses('Property', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_five_title'    => wp_kses('Development', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_five_title'    => wp_kses('Relocation', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_service_section_genaral_service_five_title }}}',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_five',
                ],
            ]
        );


        $service_six = new \Elementor\Repeater();

        $service_six->add_control(
            'vernex_service_section_genaral_service_six_thumbnail',
            [
                'label' => esc_html__('Icon Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $service_six->add_control(
            'vernex_service_section_genaral_service_six_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
            ]
        );


        $service_six->add_control(
            'vernex_service_section_genaral_service_six_title_url',
            [
                'label' => esc_html__('Title URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $service_six->add_control(
            'vernex_service_section_genaral_service_six_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Conduct a thoroug need effortless assessment the understand your current marketing.'),
                'label_block' => true,
            ]
        );

        $service_six->add_control(
            'vernex_service_section_genaral_service_six_button_text',
            [
                'label'     => esc_html__('Button Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LEARN MORE'),
                'label_block' => true,
            ]
        );

        $service_six->add_control(
            'vernex_service_section_genaral_service_six_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_service_six_list',
            [
                'label'     => esc_html__('Service List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $service_six->get_controls(),
                'default'   => [
                    [
                        'vernex_service_section_genaral_service_six_title'    => wp_kses('Residential', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_six_title'    => wp_kses('Commercial', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_six_title'    => wp_kses('Property', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_six_title'    => wp_kses('Development', wp_kses_allowed_html('post')),

                    ],
                    [
                        'vernex_service_section_genaral_service_six_title'    => wp_kses('Relocation', wp_kses_allowed_html('post')),

                    ],
                ],
                'title_field'    => '{{{ vernex_service_section_genaral_service_six_title }}}',
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_six',
                ],
            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_service_three_all_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('View All Services'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_one', 'style_three', 'style_four', 'style_six']
                ],

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_service_three_all_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => ['style_one', 'style_three', 'style_four', 'style_six']
                ],
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_service_section_genaral_style_one_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_ddescription',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_ddescription_typ',
                'selector' => '{{WRAPPER}} .home1-service-section .section-content p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_ddescription_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .section-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_description_typ',
                'selector' => '{{WRAPPER}} .home1-service-section .section-content p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .section-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_service_title_typ',
                'selector' => '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services h3 a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services h3 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_service_description_typ',
                'selector' => '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_tag_list',
            [
                'label'     => esc_html__('Tags', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_service_tag_list_typ',
                'selector' => '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content .tag-list li a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_tag_list_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content .tag-list li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_tag_list_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content .tag-list li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_tag_list_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content .tag-list li a' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_tag_list_hover_bg_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .content .tag-list li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_service_button_typ',
                'selector' => '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .button-area a i',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .button-area a i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_button_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .button-area a:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .button-area a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_button_bg_hover_color',
            [
                'label'     => esc_html__('Hover Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home1-service-section .sevices-wrap .single-services .button-area a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_bottom_button',
            [
                'label'     => esc_html__('Bottom Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_one_general_style_service_bottom_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_bottom_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_bottom_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_bottom_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_bottom_button_icon_after_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_one_general_style_service_bottom_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_service_section_genaral_style_two_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_two',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_two_general_style_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_two_general_style_service_title_typ',
                'selector' => '{{WRAPPER}} .home2-service-section .service-list li h2 a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_two_general_style_service_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-service-section .service-list li h2 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_two_general_style_service_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-service-section .service-list li h2 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_service_section_genaral_style_three_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_three',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_three_general_style_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_three_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_three_general_style_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_number',
            [
                'label'     => esc_html__('Service Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_three_general_style_service_number_typ',
                'selector' => '{{WRAPPER}} .home3-service-section .service-list .single-service .service-content span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_number_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service .service-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_number_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service:hover .service-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_three_general_style_service_title_typ',
                'selector' => '{{WRAPPER}} .home3-service-section .service-list .single-service .service-content h5 a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service .service-content h5 a' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service:hover .service-content h5 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_title_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service .service-content h5 svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_title_hover_icon_color',
            [
                'label'     => esc_html__('Hover Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service:hover .service-content h5 svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_bg',
            [
                'label'     => esc_html__('Service Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-service-section .service-list .single-service' => 'background: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_bottom_button',
            [
                'label'     => esc_html__('Bottom Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_three_general_style_service_bottom_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_bottom_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_bottom_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_bottom_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_three_general_style_service_bottom_button_after_con_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_service_section_genaral_style_four_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_four',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_four_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_four_general_style_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_button_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_button_background_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_four_general_style_service_title_typ',
                'selector' => '{{WRAPPER}} .service-card .service-content h4 a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_service_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-card .service-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_service_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-card .service-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_service_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_four_general_style_service_description_typ',
                'selector' => '{{WRAPPER}} .service-card .service-content p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_four_general_style_service_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-card .service-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_service_section_genaral_style_five_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_five',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_five_general_style_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.four span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_five_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_five_general_style_service_title_typ',
                'selector' => '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 h3 a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 h3 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 h3 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_five_general_style_service_description_typ',
                'selector' => '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_button',
            [
                'label'     => esc_html__('Service Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_five_general_style_service_button_typ',
                'selector' => '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 .more-btn',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 .more-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_button_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 .more-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2 .more-btn' => 'background: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_background',
            [
                'label'     => esc_html__('Section Card & Backgound', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_background_card_color',
            [
                'label'     => esc_html__('Card Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section .service-slider-area .service-card2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_five_general_style_service_background_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-service-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_service_section_genaral_style_six_general_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_service_section_genaral_style_selection' => 'style_six',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_six_general_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title.white h2',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.white h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_six_general_style_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn3.white span',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3.white span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3.white' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_button_border_bottom_color',
            [
                'label'     => esc_html__('Border Bottom Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3.white span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3.white span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_button_icon_after_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3.white span::after' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_title',
            [
                'label'     => esc_html__('Service Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_six_general_style_service_title_typ',
                'selector' => '{{WRAPPER}} .home6-service-section .service-wrapper .single-service h4 a',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-service-section .service-wrapper .single-service h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_title_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-service-section .service-wrapper .single-service h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_description',
            [
                'label'     => esc_html__('Service Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_six_general_style_service_description_typ',
                'selector' => '{{WRAPPER}} .home6-service-section .service-wrapper .single-service p',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-service-section .service-wrapper .single-service p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_button',
            [
                'label'     => esc_html__('Service Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_section_genaral_style_six_general_style_service_button_typ',
                'selector' => '{{WRAPPER}} .home6-service-section .service-wrapper .single-service .more-btn',

            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-service-section .service-wrapper .single-service .more-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_button_bottom_border_color',
            [
                'label'     => esc_html__('Bottom Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-service-section .service-wrapper .single-service .more-btn' => 'background: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_bg',
            [
                'label'     => esc_html__('Service Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_style_six_general_style_service_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-service-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $service_one = $settings['vernex_service_section_genaral_service_three_service_list'];
        $service_two = $settings['vernex_service_section_genaral_service_two_service_list'];
        $service_three = $settings['vernex_service_section_genaral_service_s_three_list'];
        $service_four  = $settings['vernex_service_section_genaral_service_four_service_list'];
        $service_five = $settings['vernex_service_section_genaral_service_five_list'];
        $service_six = $settings['vernex_service_section_genaral_service_six_list'];

?>

        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home5-service-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 25,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: ".swiper-pagination1",
                        clickable: true,
                    },
                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 1,
                            spaceBetween: 15,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 15,
                        },
                        992: {
                            slidesPerView: 3,
                        },
                        1200: {
                            slidesPerView: 4,
                            spaceBetween: 15,
                        },
                        1400: {
                            slidesPerView: 4,
                        },
                    },
                });
            </script>
        <?php endif; ?>


        <?php if ($settings['vernex_service_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-service-section">
                <div class="container">
                    <div class="row justify-content-between align-items-end mb-80 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-4">
                            <div class="section-title">
                                <?php if (!empty($settings['vernex_service_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_service_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_service_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_service_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['vernex_service_section_genaral_short_description'])) : ?>
                            <div class="col-lg-4">
                                <div class="section-content">
                                    <p><?php echo esc_html($settings['vernex_service_section_genaral_short_description']); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="row mb-70">
                        <div class="col-lg-12">
                            <ul class="sevices-wrap">
                                <?php foreach ($service_one as $service) : ?>
                                    <li class="single-services mb-20 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <?php if (!empty($service['vernex_service_section_genaral_service_three_title'])) : ?>
                                            <h3><a href="<?php echo esc_url($service['vernex_service_section_genaral_service_three_title_url']['url']); ?>"><?php echo wp_kses($service['vernex_service_section_genaral_service_three_title'], wp_kses_allowed_html('post')); ?></a></h3>
                                        <?php endif; ?>
                                        <div class="content">
                                            <?php if (!empty($service['vernex_service_section_genaral_service_three_description'])) : ?>
                                                <p><?php echo esc_html($service['vernex_service_section_genaral_service_three_description']); ?></p>
                                            <?php endif; ?>
                                            <ul class="tag-list">
                                                <?php
                                                $single_value = explode("\n", str_replace("\r", "", $service['vernex_service_section_genaral_service_three_tag_list']));
                                                foreach ($single_value as $sng) { ?>
                                                    <li>
                                                        <?php echo sprintf(__('%s', 'vernex-core'), $sng); ?>
                                                    </li>
                                                <?php
                                                }
                                                ?>
                                            </ul>
                                        </div>
                                        <?php if (!empty($service['vernex_service_section_genaral_service_three_button_url']['url'])) : ?>
                                            <div class="button-area">
                                                <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_three_button_url']['url']); ?>">
                                                    <i class="bi bi-arrow-right"></i>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <?php if (!empty($settings['vernex_service_section_genaral_service_three_all_button_text'])) : ?>
                        <div class="row">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <a href="<?php echo esc_url($settings['vernex_service_section_genaral_service_three_all_button_url']['url']); ?>" class="primary-btn2 bounce_up">
                                    <span>
                                        <?php echo esc_html($settings['vernex_service_section_genaral_service_three_all_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_service_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home2-service-section mb-120">
                <div class="container">
                    <ul class="service-list">
                        <?php foreach ($service_two as $service) : ?>
                            <li>
                                <?php if (!empty($service['vernex_service_section_genaral_service_two_title'])) : ?>
                                    <h2><a href="<?php echo esc_url($service['vernex_service_section_genaral_service_two_title_url']['url']); ?>"><?php echo esc_html($service['vernex_service_section_genaral_service_two_title']); ?>
                                            <?php if (!empty($service['vernex_service_section_genaral_service_two_thumbnail']['url'])) : ?>
                                                <img src="<?php echo esc_url($service['vernex_service_section_genaral_service_two_thumbnail']['url']); ?>" alt="<?php echo esc_attr__('thumbnail-image', 'vernex-core'); ?>" class="service-img">
                                            <?php endif; ?>
                                        </a></h2>
                                <?php endif; ?>
                            </li>
                            <?php if (!empty($service['vernex_service_section_genaral_service_two_icon'])) : ?>
                                <li>
                                    <?php \Elementor\Icons_Manager::render_icon($service['vernex_service_section_genaral_service_two_icon']); ?>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_service_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home3-service-section">
                <div class="container">
                    <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xxl-7 col-xl-8 col-lg-9">
                            <div class="section-title three text-center">
                                <?php if (!empty($settings['vernex_service_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_service_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_service_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_service_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_service_section_genaral_short_description'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_service_section_genaral_short_description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row g-0 mb-60">
                        <div class="col-lg-7">
                            <ul class="service-list">
                                <?php foreach ($service_three as $service) : ?>
                                    <li class="single-service wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <div class="service-content">
                                            <?php if (!empty($service['vernex_service_section_genaral_service_s_three_number'])) : ?>
                                                <span><?php echo esc_html($service['vernex_service_section_genaral_service_s_three_number']); ?></span>
                                            <?php endif; ?>
                                            <h5>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_s_three_title'])) : ?>
                                                    <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_s_three_title_url']['url']); ?>"><?php echo esc_html($service['vernex_service_section_genaral_service_s_three_title']); ?>
                                                    </a>
                                                <?php endif; ?>
                                                <svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M12.7606 11.8843L0.876899 -5.73629e-07L-3.83304e-08 0.876897L11.8843 12.7606L3.66748 12.7606L3.66748 14L14 14L14 3.66748L12.7606 3.66748L12.7606 11.8843Z" />
                                                </svg>
                                            </h5>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>

                        <div class="col-lg-5">
                            <ul class="service-img-group">
                                <?php foreach ($service_three as $service) : ?>
                                    <li class="active">
                                        <?php if (!empty($service['vernex_service_section_genaral_service_s_three_thumbnail']['url'])) : ?>
                                            <div class="service-img">
                                                <img src="<?php echo esc_url($service['vernex_service_section_genaral_service_s_three_thumbnail']['url']); ?>" alt="<?php echo esc_attr__('thumbnail-image', 'vernex-core'); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <?php if (!empty($settings['vernex_service_section_genaral_service_three_all_button_text'])) : ?>
                        <div class="row bounce_up">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <a href="<?php echo esc_url($settings['vernex_service_section_genaral_service_three_all_button_url']['url']); ?>" class="primary-btn">
                                    <?php echo esc_html($settings['vernex_service_section_genaral_service_three_all_button_text']); ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_service_section_genaral_style_selection'] == 'style_four') : ?>
            <div class="home4-service-section">
                <div class="container">
                    <div class="row g-4 align-items-center justify-content-between mb-80 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <?php if (!empty($settings['vernex_service_section_genaral_s_four_title'])) : ?>
                            <div class="col-xxl-6 col-lg-7 col-sm-6">
                                <div class="section-title2">
                                    <h2><?php echo wp_kses($settings['vernex_service_section_genaral_s_four_title'], wp_kses_allowed_html('post')); ?><span></span></h2>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($settings['vernex_service_section_genaral_service_three_all_button_text'])) : ?>
                            <div class="col-lg-2 col-md-5 col-sm-6 d-flex justify-content-sm-end">
                                <a href="<?php echo esc_url($settings['vernex_service_section_genaral_service_three_all_button_url']['url']); ?>" class="primary-btn2">
                                    <span>
                                        <?php echo esc_html($settings['vernex_service_section_genaral_service_three_all_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="row g-4">
                        <?php
                        $classes = array('', 'pt-20', '');
                        $class_count = count($classes);
                        foreach ($service_four as $index => $service) : // Use $index from the foreach loop
                            $class = $classes[$index % $class_count]; // Get class based on current index 
                        ?>
                            <div class="col-lg-4 col-md-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="service-card <?php echo $class; ?>">
                                    <div class="service-img-wrap">
                                        <?php if (!empty($service['vernex_service_section_genaral_service_four_thumbnail']['url'])) : ?>
                                            <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_four_service_title_url']['url']); ?>" class="service-img"><img src="<?php echo esc_url($service['vernex_service_section_genaral_service_four_thumbnail']['url']); ?>" alt="<?php echo esc_attr__('thumbnail-image', 'vernex-core'); ?>"></a>
                                        <?php endif; ?>
                                        <?php if (!empty($service['vernex_service_section_genaral_service_four_service_button'])) : ?>
                                            <div class="button-area">
                                                <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_four_service_button_url']['url']); ?>" class="primary-btn2 white-bg">
                                                    <span>
                                                        <?php echo esc_html($service['vernex_service_section_genaral_service_four_service_button']); ?>
                                                        <svg viewBox="0 0 13 20">
                                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="service-content">
                                        <?php if (!empty($service['vernex_service_section_genaral_service_four_service_title'])) : ?>
                                            <h4><a href="<?php echo esc_url($service['vernex_service_section_genaral_service_four_service_title_url']['url']); ?>"><?php echo esc_html($service['vernex_service_section_genaral_service_four_service_title']); ?></a></h4>
                                        <?php endif; ?>
                                        <?php if (!empty($service['vernex_service_section_genaral_service_four_service_description'])) : ?>
                                            <p><?php echo esc_html($service['vernex_service_section_genaral_service_four_service_description']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_service_section_genaral_style_selection'] == 'style_five') : ?>
            <div class="home5-service-section">
                <div class="container">
                    <div class="row mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-12 d-flex justify-content-center">
                            <div class="section-title four">
                                <?php if (!empty($settings['vernex_service_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_service_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_service_section_genaral_s_four_title'])) : ?>
                                    <h2><?php echo wp_kses($settings['vernex_service_section_genaral_s_four_title'], wp_kses_allowed_html('post')); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="service-slider-area">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="swiper home5-service-slider">
                                <div class="swiper-wrapper">
                                    <?php foreach ($service_five as $service) : ?>
                                        <div class="swiper-slide">
                                            <div class="service-card2">
                                                <?php if (!empty($service['vernex_service_section_genaral_service_five_icon'])) : ?>
                                                    <div class="icon">
                                                        <?php \Elementor\Icons_Manager::render_icon($service['vernex_service_section_genaral_service_five_icon']); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_five_title'])) : ?>
                                                    <h3><a href="<?php echo esc_url($service['vernex_service_section_genaral_service_five_title_url']['url']); ?>"><?php echo esc_html($service['vernex_service_section_genaral_service_five_title']); ?></a></h3>
                                                <?php endif; ?>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_five_description'])) : ?>
                                                    <p><?php echo esc_html($service['vernex_service_section_genaral_service_five_description']); ?></p>
                                                <?php endif; ?>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_five_button_text'])) : ?>
                                                    <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_five_button_url']['url']); ?>" class="more-btn"><?php echo esc_html($service['vernex_service_section_genaral_service_five_button_text']); ?></a>
                                                    <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_five_button_url']['url']); ?>" class="arrow">
                                                        <svg width="80" height="80" viewBox="0 0 80 80" xmlns="http://www.w3.org/2000/svg">
                                                            <g>
                                                                <path
                                                                    d="M79.604 79.999L0 79.999L-1.30275e-06 65.0973L64.9505 0.000230198L80 0.000228882L80 14.902L35.6436 58.8229L79.604 58.4307L79.604 79.999Z" />
                                                                <path
                                                                    d="M0.000577353 -9.57446e-06L0.000581741 50.1953L21.3867 29.0192L21.3867 -1.14441e-05L0.000577353 -9.57446e-06Z" />
                                                            </g>
                                                        </svg>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if (!empty($settings['vernex_service_section_genaral_show_pagination']) == 'yes') : ?>
                        <div class="row pt-50">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <div class="pagination-area">
                                    <div class="pagination swiper-pagination1"></div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_service_section_genaral_style_selection'] == 'style_six') : ?>
            <div class="home6-service-section">
                <div class="container-fluid">
                    <div class="row gy-5 align-items-center">
                        <div class="col-xl-4 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <?php if (!empty($settings['vernex_service_section_genaral_title'])) : ?>
                                <div class="section-title white">
                                    <h2><?php echo esc_html($settings['vernex_service_section_genaral_title']); ?></h2>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($settings['vernex_service_section_genaral_service_three_all_button_text'])) : ?>
                                <a href="<?php echo esc_url($settings['vernex_service_section_genaral_service_three_all_button_url']['url']); ?>" class="primary-btn3 white">
                                    <span>
                                        <?php echo esc_html($settings['vernex_service_section_genaral_service_three_all_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                    <i class="corner tl"></i>
                                    <i class="corner tr"></i>
                                    <i class="corner br"></i>
                                    <i class="corner bl"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                        <div class="col-xl-8">
                            <div class="service-wrapper">
                                <div class="row g-lg-3 gy-5 divider">
                                    <?php $classes = array('br pl-0', 'br', 'pr-0', 'br pl-0', 'br', 'pr-0');
                                    $class_count = count($classes);
                                    foreach ($service_six as $index => $service) :
                                        $class = $classes[$index % $class_count];
                                    ?>

                                        <div class="col-lg-4 col-sm-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                            <div class="single-service <?php echo $class; ?>">
                                                <?php if (!empty($service['vernex_service_section_genaral_service_six_title'])) : ?>
                                                    <h4><a href="<?php echo esc_url($service['vernex_service_section_genaral_service_six_title_url']['url']); ?>"><?php echo wp_kses($service['vernex_service_section_genaral_service_six_title'], wp_kses_allowed_html('post')); ?></a></h4>
                                                <?php endif; ?>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_six_description'])) : ?>
                                                    <p><?php echo esc_html($service['vernex_service_section_genaral_service_six_description']); ?></p>
                                                <?php endif; ?>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_six_button_text'])) : ?>
                                                    <a href="<?php echo esc_url($service['vernex_service_section_genaral_service_six_button_url']['url']); ?>" class="more-btn"><?php echo esc_html($service['vernex_service_section_genaral_service_six_button_text']); ?></a>
                                                <?php endif; ?>
                                                <?php if (!empty($service['vernex_service_section_genaral_service_six_thumbnail']['url'])) : ?>
                                                    <img src="<?php echo esc_url($service['vernex_service_section_genaral_service_six_thumbnail']['url']); ?>" alt="<?php echo esc_attr__('thumbnail-image', 'vernex-core'); ?>" class="service-img">
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>



<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Service_Widget());
