<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Service_Details_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_service_details';
    }

    public function get_title()
    {
        return esc_html__('EG Service Details', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_service_details_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_service_details_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Residential <span>Construction</span>', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_details_section_genaral_short_content_list',
            [
                'label'     => esc_html__('Header Content List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses('Family Homes
Single Home
Custom Homes
Home Additions', wp_kses_allowed_html('post')),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_details_section_genaral_short_description',
            [
                'label' => esc_html__('Short Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html('Where innovation meets passion in a journey that started with a simple idea and a shared dream. Founded in recent year we embarked on a mission to bring the new innovation and introduce the technology. From humble beginnings to our current aspirations, every step has been fueled by a relentless commitment.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),

            ]
        );

        $this->add_control(
            'vernex_service_details_section_genaral_short_content_list_two',
            [
                'label'     => esc_html__('Content List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses('Site Assessment
Home Remodeling
Design Planning
Flooring Upgrades
Foundation Work
Smart Integration', wp_kses_allowed_html('post')),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_details_section_genaral_content_title_two',
            [
                'label'       => esc_html__('Content Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Welcome to Vernex.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_service_details_section_genaral_content_description',
            [
                'label' => esc_html__('Content Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html('Where innovation meets passion in a journey that started with a simple idea and a shared dream. Founded in recent year we embarked on a mission to bring the new innovation and introduce the technology. From humble beginnings to our current aspirations, every step has been fueled by a relentless commitment.

Where innovation meets passion in a journey that started with a simple idea and a shared dream. Founded in recent year we embarked on a mission to bring the new innovation and introduce the technology. From humble beginnings to.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your description here', 'vernex-core'),

            ]
        );


        $this->add_control(
            'vernex_service_section_genaral_service_details_image_one',
            [
                'label' => esc_html__('Image One', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_service_section_genaral_service_details_image_two',
            [
                'label' => esc_html__('Image Two', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'vernex_service_details_section_faq_genaral',
            [
                'label' => esc_html__('FAQ', 'vernex-core')
            ]
        );

        $faq_one = new \Elementor\Repeater();

        // accordion title
        $faq_one->add_control(
            'vernex_service_details_section_faq_genaral_question',
            [
                'label' => esc_html__('Question', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Cassian Coleson'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your question here', 'vernex-core'),
            ]
        );

        // accordion Description
        $faq_one->add_control(
            'vernex_service_details_section_faq_genaral_answer',
            [
                'label' => esc_html__('Answer', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Founder at, Nexaq'),
                'placeholder' => esc_html__('Type your answer here', 'vernex-core'),
            ]
        );

        $this->add_control(
            'vernex_service_details_section_faq_genaral_list',
            [
                'label' => esc_html__('FAQ List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $faq_one->get_controls(),
                'default' => [
                    [
                        'vernex_service_details_section_faq_genaral_question' => esc_html('01. Do you provide design and architectural services?'),
                        'vernex_service_details_section_faq_genaral_answer' => esc_html('Yes, we offer comprehensive design and architectural services to meet your construction needs, ensuring a seamless process from concept to completion.'),

                    ],
                    [
                        'vernex_service_details_section_faq_genaral_question' => esc_html('02. Is Vernex suitable for my business?'),
                        'vernex_service_details_section_faq_genaral_answer' => esc_html('Discover if Vernex is the right fit for your business by exploring its tailored solutions for various industries and unique needs.'),

                    ],
                    [
                        'vernex_service_details_section_faq_genaral_question' => esc_html('03. What is your typical project timeline?'),
                        'vernex_service_details_section_faq_genaral_answer' => esc_html('Discover the typical project timeline for our construction services, outlining each phase from planning to completion, ensuring timely and efficient project delivery.'),

                    ],
                    [
                        'vernex_service_details_section_faq_genaral_question' => esc_html('04. How do you handle permits and inspections?'),
                        'vernex_service_details_section_faq_genaral_answer' => esc_html('We handle all necessary permits and inspections for your project, ensuring full compliance with local regulations and smooth progress throughout the construction process.'),

                    ],
                    [
                        'vernex_service_details_section_faq_genaral_question' => esc_html('05. How do you handle waste disposal and recycling?'),
                        'vernex_service_details_section_faq_genaral_answer' => esc_html('At our construction sites, we prioritize responsible waste disposal and recycling by adhering to local regulations, implementing sustainable practices, and partnering with certified waste management services to minimize environmental impact.'),

                    ],
                    [
                        'vernex_service_details_section_faq_genaral_question' => esc_html('06. How do ensure buildings are structurally safe?'),
                        'vernex_service_details_section_faq_genaral_answer' => esc_html('Learn how we prioritize safety in construction by following strict structural guidelines and using high-quality materials to ensure buildings are secure and reliable.'),

                    ],

                ],
                'title_field' => '{{{ vernex_service_details_section_faq_genaral_question }}}',
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'vernex_service_details_style_general',
            [
                'label' => esc_html__('General', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_title_typ',
                'selector' => '{{WRAPPER}} .service-details-page .title-area h2',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details-page .title-area h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_title_span_color',
            [
                'label'     => esc_html__('Span Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details-page .title-area h2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_header_content_list',
            [
                'label'     => esc_html__('Header Content List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_header_content_list_typ',
                'selector' => '{{WRAPPER}} .service-details-page .title-area .tag-list li',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_header_content_list_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details-page .title-area .tag-list li' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_service_details_style_general_header_content_list_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details-page .title-area .tag-list li' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );



        $this->add_control(
            'vernex_service_details_style_general_header_description',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_header_description_typ',
                'selector' => '{{WRAPPER}} .details-content-wrapper p',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_header_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .details-content-wrapper p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_heder_content_list',
            [
                'label'     => esc_html__('Content List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_heder_content_list_typ',
                'selector' => '{{WRAPPER}} .details-content-wrapper ul li',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_heder_content_list_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .details-content-wrapper ul li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_content_title',
            [
                'label'     => esc_html__('Content Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_content_title_typ',
                'selector' => '{{WRAPPER}} .details-content-wrapper h3',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .details-content-wrapper h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_faq_question',
            [
                'label'     => esc_html__('FAQ Question', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_faq_question_typ',
                'selector' => '{{WRAPPER}} .faq-wrap .accordion .accordion-item:first-child .accordion-header .accordion-button',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_faq_question_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion .accordion-item:first-child .accordion-header .accordion-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_faq_answer',
            [
                'label'     => esc_html__('FAQ Answer', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_service_details_style_general_faq_answer_typ',
                'selector' => '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-body',

            ]
        );

        $this->add_control(
            'vernex_service_details_style_general_faq_answer_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-body' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
?>

        <div class="service-details-page">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="service-details-thumb mb-60">
                            <img src="assets/img/inner-pages/service-details-thumb-img.jpg" alt="">
                        </div>
                        <div class="title-area mb-60">
                            <?php if (!empty($settings['vernex_service_details_section_genaral_title'])) : ?>
                                <h2><?php echo wp_kses($settings['vernex_service_details_section_genaral_title'], wp_kses_allowed_html('post')); ?></h2>
                            <?php endif; ?>
                            <ul class="tag-list">
                                <?php
                                $single_value = explode("\n", str_replace("\r", "", $settings['vernex_service_details_section_genaral_short_content_list']));
                                foreach ($single_value as $sng) { ?>
                                    <li>
                                        <?php echo sprintf(__('%s', 'vernex-core'), $sng); ?>
                                    </li>
                                <?php
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row g-lg-4 gy-5 mb-120">
                    <div class="col-lg-6">
                        <div class="details-content-wrapper">
                            <?php if (!empty($settings['vernex_service_details_section_genaral_short_description'])) : ?>
                                <p><?php echo esc_html($settings['vernex_service_details_section_genaral_short_description']); ?></p>
                            <?php endif; ?>
                            <span class="line-break"></span>
                            <span class="line-break"></span>
                            <ul>
                                <?php
                                $single_value = explode("\n", str_replace("\r", "", $settings['vernex_service_details_section_genaral_short_content_list_two']));
                                foreach ($single_value as $sng) { ?>
                                    <li>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">
                                            <path
                                                d="M0.376831 8.16821C-0.247095 8.54593 -0.0579659 9.49862 0.662688 9.60837C1.24211 9.69666 1.52052 10.3701 1.17304 10.8431C0.740845 11.4312 1.27942 12.2389 1.98713 12.0639C2.55609 11.9231 3.07065 12.4387 2.9302 13.0088C2.75556 13.718 3.56158 14.2577 4.14855 13.8246C4.62054 13.4764 5.29275 13.7554 5.38073 14.336C5.49024 15.0581 6.44099 15.2476 6.81798 14.6224C7.12107 14.1198 7.84864 14.1198 8.15171 14.6224C8.52867 15.2476 9.47943 15.0581 9.58896 14.336C9.67707 13.7554 10.3492 13.4764 10.8211 13.8246C11.4081 14.2577 12.2142 13.718 12.0395 13.0088C11.899 12.4387 12.4136 11.9231 12.9826 12.0639C13.6903 12.2389 14.2289 11.4312 13.7967 10.8431C13.4492 10.3701 13.7276 9.69653 14.307 9.60837C15.0276 9.49864 15.2168 8.54597 14.5929 8.16821C14.0912 7.86452 14.0912 7.13547 14.5929 6.83178C15.2168 6.45407 15.0277 5.50138 14.307 5.39162C13.7276 5.30334 13.4492 4.62989 13.7967 4.15695C14.2289 3.56879 13.6903 2.76112 12.9826 2.93613C12.4136 3.07687 11.8991 2.5613 12.0395 1.99115C12.2141 1.28199 11.4081 0.742345 10.8211 1.17541C10.3492 1.52356 9.67695 1.2446 9.58896 0.664029C9.47945 -0.0580599 8.5287 -0.247606 8.15171 0.377594C7.84863 0.880237 7.12106 0.880237 6.81798 0.377594C6.44103 -0.247596 5.49027 -0.0580833 5.38073 0.664029C5.29263 1.24462 4.62054 1.5236 4.14855 1.17541C3.56158 0.742345 2.75554 1.28201 2.9302 1.99115C3.07065 2.56126 2.55612 3.07686 1.98713 2.93613C1.2794 2.76113 0.740845 3.56879 1.17304 4.15695C1.52049 4.62989 1.24209 5.30346 0.662688 5.39162C-0.0579425 5.50136 -0.247105 6.45403 0.376831 6.83178C0.878459 7.13548 0.878459 7.86453 0.376831 8.16821Z" />
                                        </svg>
                                        <?php echo sprintf(__('%s', 'vernex-core'), $sng); ?>
                                    </li>
                                <?php
                                }
                                ?>
                            </ul>
                            <span class="line-break"></span>
                            <span class="line-break"></span>
                            <?php if (!empty($settings['vernex_service_details_section_genaral_content_title_two'])) : ?>
                                <h3><?php echo esc_html($settings['vernex_service_details_section_genaral_content_title_two']); ?></h3>
                            <?php endif; ?>
                            <span class="line-break"></span>
                            <?php if (!empty($settings['vernex_service_details_section_genaral_content_description'])) : ?>
                                <p><?php echo wp_kses($settings['vernex_service_details_section_genaral_content_description'], wp_kses_allowed_html('post')); ?></p>
                            <?php endif; ?>
                            <span class="line-break"></span>
                            <div class="service-details-img-grp">
                                <div class="row g-lg-3 g-4">
                                    <div class="col-md-6">
                                        <img src="<?php echo esc_url($settings['vernex_service_section_genaral_service_details_image_one']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <img src="<?php echo esc_url($settings['vernex_service_section_genaral_service_details_image_two']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-lg-6">
                        <div class="service-details-faq-area">
                            <div class="faq-wrap style-2">
                                <div class="accordion" id="accordionExample">
                                    <?php
                                    $accordion_items = $this->get_settings('vernex_service_details_section_faq_genaral_list');
                                    if (!empty($accordion_items)) {
                                        $index = 0;
                                    ?>
                                        <div class="accordion" id="accordionGeneral">
                                            <?php foreach ($accordion_items as $item) :
                                                $is_active = ($index === 0) ? 'show' : '';
                                            ?>
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="faqheadingOne<?php echo $index; ?>">
                                                        <button class="accordion-button <?php echo ($index === 0) ? '' : 'collapsed'; ?>"
                                                            type="button"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#faqcollapse<?php echo $index; ?>"
                                                            aria-expanded="<?php echo ($index === 0) ? 'true' : 'false'; ?>"
                                                            aria-controls="faqcollapse<?php echo $index; ?>">
                                                            <?php if (!empty($item['vernex_service_details_section_faq_genaral_question'])) : ?>
                                                                <?php echo esc_html($item['vernex_service_details_section_faq_genaral_question']); ?>
                                                            <?php endif; ?>
                                                        </button>
                                                    </h2>
                                                    <div id="faqcollapse<?php echo $index; ?>"
                                                        class="accordion-collapse collapse <?php echo $is_active; ?>"
                                                        aria-labelledby="faqheadingOne<?php echo $index; ?>"
                                                        data-bs-parent="#accordionGeneral">
                                                        <div class="accordion-body">
                                                            <?php if (!empty($item['vernex_service_details_section_faq_genaral_answer'])) : ?>
                                                                <?php echo esc_html($item['vernex_service_details_section_faq_genaral_answer']); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                                $index++;
                                            endforeach; ?>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Service_Details_Widget());
