<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Scroll_Text_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_scroll_text';
    }

    public function get_title()
    {
        return esc_html__('EG Scroll Text', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_scroll_text_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );
        // Repeater
        $scroll_one = new \Elementor\Repeater();

        $scroll_one->add_control(
            'vernex_scroll_text_section_genaral_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );

        // accordion title
        $scroll_one->add_control(
            'vernex_scroll_text_section_genaral_text',
            [
                'label' => esc_html__('Scroll Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Cassian Coleson'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_genaral_list',
            [
                'label' => esc_html__('Scroll Text List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $scroll_one->get_controls(),
                'default' => [
                    [
                        'vernex_scroll_text_section_genaral_text' => esc_html('Quality Real Estate Property, Timely Delivery'),
                    ],
                    [
                        'vernex_scroll_text_section_genaral_text' => esc_html('Transforming Visions into Reality'),
                    ],
                    [
                        'vernex_scroll_text_section_genaral_text' => esc_html('Building a Better Tomorrow, Today'),
                    ],
                    [
                        'vernex_scroll_text_section_genaral_text' => esc_html('Your Trusted Partner in All Building'),
                    ],
                    [
                        'vernex_scroll_text_section_genaral_text' => esc_html('Quality Real Estate Property, Timely Delivery'),
                    ],


                ],
                'title_field' => '{{{ vernex_scroll_text_section_genaral_text }}}',

            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_scroll_text_section_style_one_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_style_one_general_text_scroll',
            [
                'label'     => esc_html__('Scroll Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_scroll_text_section_style_one_general_text_scroll_typ',
                'selector' => '{{WRAPPER}} .home2-scroll-text-section .scroll-text h6',

            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_style_one_general_text_scroll_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-scroll-text-section .scroll-text h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_style_one_general_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-scroll-text-section .scroll-text svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_style_one_general_text_scroll_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-scroll-text-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $scroll_text = $settings['vernex_scroll_text_section_genaral_list'];
?>

        <div class="home2-scroll-text-section <?php if($settings['vernex_scroll_text_section_genaral_style_selection'] == 'style_two') : ?>two<?php endif; ?>">
            <div class="scroll-text">
                <?php foreach ($scroll_text as $scroll) : ?>
                    <?php if (!empty($scroll['vernex_scroll_text_section_genaral_icon'])) : ?>
                        <?php \Elementor\Icons_Manager::render_icon($scroll['vernex_scroll_text_section_genaral_icon']); ?>
                    <?php endif ?>
                    <?php if (!empty($scroll['vernex_scroll_text_section_genaral_text'])) : ?>
                        <h6><?php echo esc_html($scroll['vernex_scroll_text_section_genaral_text']); ?></h6>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>

            <div aria-hidden="true" class="scroll-text">
                <?php foreach ($scroll_text as $scroll) : ?>
                    <?php if (!empty($scroll['vernex_scroll_text_section_genaral_icon'])) : ?>
                        <?php \Elementor\Icons_Manager::render_icon($scroll['vernex_scroll_text_section_genaral_icon']); ?>
                    <?php endif; ?>
                    <?php if (!empty($scroll['vernex_scroll_text_section_genaral_text'])) : ?>
                        <h6><?php echo esc_html($scroll['vernex_scroll_text_section_genaral_text']); ?></h6>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Scroll_Text_Widget());
