<?php

namespace Elementor;

use Egns\Helper\Egns_Helper;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly

use Elementor\core\Schemes;

class Vernex_Properties_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_properties';
    }

    public function get_title()
    {
        return esc_html__('EG Properties', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        // ---------------------------Content one--------------------------//


        $this->start_controls_section(
            'vernex_properties_section',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_properties_section_one_bottom_button',
            [
                'label' => esc_html__('Button Area', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_properties_section_one_bottom_button_text',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('All Properties', 'vernex-core'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,


            ]
        );

        $this->add_control(
            'vernex_properties_section_one_bottom_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_properties_section_genaral_query_post_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'vernex-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'selected_properties',
            [
                'label'       => __('Select Properties', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple'    => true,
                'options'     => Egns_Helper::get_properties_post_option(),
            ]
        );



        $this->add_control(
            'vernex_properties_section_genaral_query_orderby',
            [
                'label'   => esc_html__('Order By', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'vernex-core'),
                    'author'     => esc_html__('Post Author', 'vernex-core'),
                    'title'      => esc_html__('Title', 'vernex-core'),
                    'post_date'  => esc_html__('Date', 'vernex-core'),
                    'rand'       => esc_html__('Random', 'vernex-core'),
                    'menu_order' => esc_html__('Menu Order', 'vernex-core'),
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_section_genaral_query_template_order',
            [
                'label'   => esc_html__('Order', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'vernex-core'),
                    'desc' => esc_html__('Descending', 'vernex-core')

                ],
                'default' => 'desc',
            ]
        );

        $this->end_controls_section();

        // =====================Style One=======================//

        $this->start_controls_section(
            'vernex_properties_style',
            [
                'label' => esc_html__('General', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,


            ]
        );

        $this->add_control(
            'vernex_properties_style_content_price',
            [
                'label'     => esc_html__('Price', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_properties_style_content_pricetyp',
                'selector' => '{{WRAPPER}} .property-card .property-img-wrap .price span',

            ]
        );

        $this->add_control(
            'vernex_properties_style_content_price_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .property-card .property-img-wrap .price span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_style_content_price_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .property-card .property-img-wrap .price span' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_style_properties_content',
            [
                'label'     => esc_html__('Properties Content', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_properties_style_properties_content_typ',
                'selector' => '{{WRAPPER}} .property-card .property-content ul li',

            ]
        );

        $this->add_control(
            'vernex_properties_style_properties_content_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .property-card .property-content ul li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_properties_style_title_typ',
                'selector' => '{{WRAPPER}} .property-card .property-content h5 a',

            ]
        );

        $this->add_control(
            'vernex_properties_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .property-card .property-content h5 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_style_title_hov_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .property-card .property-content h5 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_style_btn',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_properties_style_btn_typ',
                'selector' => '{{WRAPPER}} .primary-btn',

            ]
        );

        $this->add_control(
            'vernex_properties_style_btn_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $selected_post_ids     = $settings['selected_properties'];

        $args = array(
            'post_type'      => 'properties',
            'posts_per_page' => $settings['vernex_properties_section_genaral_query_post_per_page'],
            'orderby'        => $settings['vernex_properties_section_genaral_query_orderby'],
            'order'          => $settings['vernex_properties_section_genaral_query_template_order'],
            'offset'         => 0,
            'post_status'    => 'publish',
        );
        if (!empty($selected_post_ids)) {
            $args['post__in'] = $selected_post_ids;
        }
        $query = new \WP_Query($args);

?>

        <?php if (is_admin()) : ?>
            <script>

            </script>
        <?php endif; ?>

        <div class="home2-property-section">
            <div class="container">
                <div class="property-grid-section mb-70">
                    <div class="row gy-5">


                        <?php
                        while ($query->have_posts()) :
                            $query->the_post();
                        ?>
                            <div class="col-lg-4 col-md-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="property-card magnetic-item">
                                    <div class="property-img-wrap">
                                        <a href="<?php the_permalink() ?>" class="property-img">
                                            <?php if (has_post_thumbnail()) : ?>
                                                <?php the_post_thumbnail(); ?>
                                            <?php endif; ?></a>
                                        <div class="price">
                                            <span> <?php echo esc_html(Egns_Helper::egns_properties_value('peoperties_regular_price')); ?></span>

                                        </div>

                                    </div>
                                    <div class="property-content">
                                        <?php $properties_short_info = Egns_Helper::egns_properties_value('properties_short_info_list');
                                        if (!empty($properties_short_info)) :  ?>
                                            <ul>
                                                <?php
                                                if (!empty(Egns_Helper::egns_properties_value('properties_short_info_list'))) :
                                                    foreach ($properties_short_info as $step_data) :
                                                ?>
                                                        <li><?php echo esc_html($step_data['properties_short_info_text']); ?></li>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <h5><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h5>

                                        <a href="<?php the_permalink() ?>" class="primary-btn">
                                            <?php echo esc_html__('View Detials', 'vernex-core'); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 d-flex justify-content-center">

                        <a href="<?php echo esc_url($settings['vernex_properties_section_one_bottom_button_url']['url']); ?>" class="primary-btn2 bounce_up">
                            <span>
                                <?php echo esc_html($settings['vernex_properties_section_one_bottom_button_text']); ?>
                                <svg viewBox="0 0 13 20">
                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                </svg>
                            </span>
                        </a>

                    </div>
                </div>
            </div>
        </div>


<?php
    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Properties_Widget());
