<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly
use Egns_Core\Egns_Helper;

class Vernex_Properties_Description_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_properties_description';
    }

    public function get_title()
    {
        return esc_html__('EG Properties Description', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_description_tab_genaral_sec',
            [
                'label' => esc_html__('Properties Tab ', 'vernex-core'),

            ]
        );

        // Title
        $this->add_control(
            'vernex_description_tab_genaral_sec_subtitle',
            [
                'label' => esc_html__('Subtitle', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Best Properties'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your subtitle here', 'vernex-core'),

            ]
        );

        $this->add_control(
            'vernex_description_tab_genaral_sec_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('What We Offer.', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),

            ]
        );

        $this->add_control(
            'vernex_description_tab_genaral_sec_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('All Properties', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_description_tab_genaral_sec_button_text_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => __('Tab Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Tab Name', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'image_url',
            [
                'label' => __('Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $repeater->add_control(
            'project_short_description',
            [
                'label' => __('Short Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero, sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse nectoraba porttitor velit go this week and more about.', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'popover-toggle',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__('Item List', 'vernex-core'),
                'label_off' => esc_html__('Default', 'vernex-core'),
                'label_on' => esc_html__('Custom', 'vernex-core'),
                'return_value' => 'yes',
            ]
        );

        $repeater->start_popover();
        $repeater->add_control(
            'vernex_properties_description_section_general_icon_one',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_title_one',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LinkedIn'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_info_text_one',
            [
                'label' => esc_html__('Info Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('3 Room'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_icon_two',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_title_two',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LinkedIn'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_info_text_two',
            [
                'label' => esc_html__('Info Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('3 Room'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_icon_three',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_title_three',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LinkedIn'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_info_text_three',
            [
                'label' => esc_html__('Info Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('3 Room'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_icon_four',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_title_four',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LinkedIn'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_info_text_four',
            [
                'label' => esc_html__('Info Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('3 Room'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_icon_five',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_title_five',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LinkedIn'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_info_text_five',
            [
                'label' => esc_html__('Info Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('3 Room'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_icon_six',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_title_six',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('TOTAL ROOM'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_description_section_general_info_text_six',
            [
                'label' => esc_html__('Info Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('3 Room'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );



        $repeater->end_popover();

        $repeater->add_control(
            'vernex_description_tab_genaral_sec_content_button_text',
            [
                'label'       => esc_html__('Content Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Read More', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'vernex_description_tab_genaral_sec_content_button_text_url',
            [
                'label' => esc_html__('Content Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'projects_tab_list',
            [
                'label' => __('Tabs with Images', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
            ]
        );


        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_description_tab_content_text_section_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_room_type',
            [
                'label'     => esc_html__('Properties Type', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_description_tab_content_text_section_style_general_room_type_typ',
                'selector' => '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-nav .nav-tabs .nav-link',

            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_room_type_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-nav .nav-tabs .nav-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_description_tab_content_text_section_style_general_room_size_typ',
                'selector' => '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content p',

            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_room_size_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content',
            [
                'label'     => esc_html__('Property Content', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        // Icon
        $this->add_control(
            'vernex_description_tab_content_icon_sec',
            [
                'label' => esc_html__(' Icon ', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_icon_sec_color',
            [
                'label' => esc_html__('Color', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .icon  >i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .icon svg ' => 'fill: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'vernex_description_tab_content_icon_sec_size',
            [
                'label' => esc_html__('Icon Size', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [],
                'selectors' => [
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .icon >svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .icon >i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_description_tab_content_text_section_style_general_desc_property_content_title_typ',
                'selector' => '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .content h6',

            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .content h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content_property',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_description_tab_content_text_section_style_general_desc_property_content_property_typ',
                'selector' => '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .content span',

            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content_property_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-description-section .property-content-wrap .property-description-tab .property-content ul li .content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content_property_btn',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_description_tab_content_text_section_style_general_desc_property_content_property_btn_typ',
                'selector' => '{{WRAPPER}} .primary-btn2',

            ]
        );

        $this->add_control(
            'vernex_description_tab_content_text_section_style_general_desc_property_content_property_btn_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $tabs = [];
        foreach ($settings['projects_tab_list'] as $item) {
            $tabs[$item['tab_title']][] = $item;
        }
?>

        <div class="home2-property-description-section">
            <div class="container">
                <div class="row mb-60">
                    <div class="col-lg-12 d-flex align-items-center justify-content-between gap-4 flex-wrap">
                        <div class="section-title two wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <?php if (!empty($settings['vernex_description_tab_genaral_sec_subtitle'])) : ?>
                                <span><?php echo esc_html($settings['vernex_description_tab_genaral_sec_subtitle']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['vernex_description_tab_genaral_sec_title'])) : ?>
                                <h2><?php echo esc_html($settings['vernex_description_tab_genaral_sec_title']); ?></h2>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($settings['vernex_description_tab_genaral_sec_button_text'])) : ?>
                            <a href="<?php echo esc_url($settings['vernex_description_tab_genaral_sec_button_text_url']['url']); ?>" class="primary-btn2 btn_wrapper">
                                <span>
                                    <?php echo esc_html($settings['vernex_description_tab_genaral_sec_button_text']); ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="property-content-wrap">
                    <div class="property-description-nav mb-50">
                        <nav>
                            <div class="nav nav-tabs" id="vernex-tab" role="tablist">
                                <?php $i = 0;
                                foreach ($tabs as $tab_title => $images) : ?>
                                    <button class="nav-link <?php echo $i === 0 ? 'active' : ''; ?>"
                                        id="tab-<?php echo $i; ?>"
                                        data-bs-toggle="tab"
                                        data-bs-target="#content-<?php echo $i; ?>"
                                        type="button" role="tab">
                                        <?php echo esc_html($tab_title); ?>
                                    </button>
                                <?php $i++;
                                endforeach; ?>
                            </div>
                        </nav>
                    </div>
                    <div class="property-description-tab">
                        <div class="tab-content" id="nav-tabContent">
                            <?php $i = 0;
                            foreach ($tabs as $tab_title => $images) : ?>
                                <div class="tab-pane fade <?php echo $i === 0 ? 'show active' : ''; ?>"
                                    id="content-<?php echo $i; ?>" role="tabpanel">
                                    <div class="row">
                                        <div class="col-lg-6 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                                            <?php foreach ($images as $content_info) : ?>
                                                <div class="property-content">
                                                    <?php if (!empty($content_info['project_short_description'])) : ?>
                                                        <p><?php echo esc_html($content_info['project_short_description']); ?></p>
                                                    <?php endif; ?>
                                                    <ul>


                                                        <li>
                                                            <?php if (!empty($content_info['vernex_properties_description_section_general_icon_one'])) : ?>
                                                                <div class="icon">
                                                                    <?php \Elementor\Icons_Manager::render_icon($content_info['vernex_properties_description_section_general_icon_one']); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_title_one'])) : ?>
                                                                    <h6><?php echo esc_html($content_info['vernex_properties_description_section_general_title_one']); ?></h6>
                                                                <?php endif; ?>
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_info_text_one'])) : ?>
                                                                    <span><?php echo esc_html($content_info['vernex_properties_description_section_general_info_text_one']); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </li>



                                                        <li>
                                                            <?php if (!empty($content_info['vernex_properties_description_section_general_icon_two'])) : ?>
                                                                <div class="icon">
                                                                    <?php \Elementor\Icons_Manager::render_icon($content_info['vernex_properties_description_section_general_icon_two']); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_title_two'])) : ?>
                                                                    <h6><?php echo esc_html($content_info['vernex_properties_description_section_general_title_two']); ?></h6>
                                                                <?php endif; ?>
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_info_text_two'])) : ?>
                                                                    <span><?php echo esc_html($content_info['vernex_properties_description_section_general_info_text_two']); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </li>




                                                        <li>
                                                            <?php if (!empty($content_info['vernex_properties_description_section_general_icon_three'])) : ?>
                                                                <div class="icon">
                                                                    <?php \Elementor\Icons_Manager::render_icon($content_info['vernex_properties_description_section_general_icon_three']); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_title_three'])) : ?>
                                                                    <h6><?php echo esc_html($content_info['vernex_properties_description_section_general_title_three']); ?></h6>
                                                                <?php endif; ?>
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_info_text_three'])) : ?>
                                                                    <span><?php echo esc_html($content_info['vernex_properties_description_section_general_info_text_three']); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </li>




                                                        <li>
                                                            <?php if (!empty($content_info['vernex_properties_description_section_general_icon_four'])) : ?>
                                                                <div class="icon">
                                                                    <?php \Elementor\Icons_Manager::render_icon($content_info['vernex_properties_description_section_general_icon_four']); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_title_four'])) : ?>
                                                                    <h6><?php echo esc_html($content_info['vernex_properties_description_section_general_title_four']); ?></h6>
                                                                <?php endif; ?>
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_info_text_four'])) : ?>
                                                                    <span><?php echo esc_html($content_info['vernex_properties_description_section_general_info_text_four']); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </li>




                                                        <li>
                                                            <?php if (!empty($content_info['vernex_properties_description_section_general_icon_five'])) : ?>
                                                                <div class="icon">
                                                                    <?php \Elementor\Icons_Manager::render_icon($content_info['vernex_properties_description_section_general_icon_five']); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_title_five'])) : ?>
                                                                    <h6><?php echo esc_html($content_info['vernex_properties_description_section_general_title_five']); ?></h6>
                                                                <?php endif; ?>
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_info_text_five'])) : ?>
                                                                    <span><?php echo esc_html($content_info['vernex_properties_description_section_general_info_text_five']); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </li>




                                                        <li>
                                                            <?php if (!empty($content_info['vernex_properties_description_section_general_icon_six'])) : ?>
                                                                <div class="icon">
                                                                    <?php \Elementor\Icons_Manager::render_icon($content_info['vernex_properties_description_section_general_icon_six']); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="content">
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_title_six'])) : ?>
                                                                    <h6><?php echo esc_html($content_info['vernex_properties_description_section_general_title_six']); ?></h6>
                                                                <?php endif; ?>
                                                                <?php if (!empty($content_info['vernex_properties_description_section_general_info_text_six'])) : ?>
                                                                    <span><?php echo esc_html($content_info['vernex_properties_description_section_general_info_text_six']); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </li>

                                                    </ul>

                                                    <?php if (!empty($content_info['vernex_description_tab_genaral_sec_content_button_text'])) : ?>
                                                        <a href="<?php echo esc_url($content_info['vernex_description_tab_genaral_sec_content_button_text_url']['url']); ?>" class="primary-btn2 transparent">
                                                            <span>
                                                                <?php echo esc_html($content_info['vernex_description_tab_genaral_sec_content_button_text']); ?>
                                                                <svg viewBox="0 0 13 20">
                                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <div class="col-lg-6 d-lg-block d-none wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                            <?php foreach ($images as $content_info) : ?>
                                                <?php if (!empty($content_info['image_url']['url'])) : ?>
                                                    <div class="property-img">
                                                        <img src="<?php echo esc_url($content_info['image_url']['url']); ?>" alt="<?php echo esc_attr__('image', 'vernex-core'); ?>">
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php $i++;
                            endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Properties_Description_Widget());