<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Properties_Banner_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_properties_banner';
    }

    public function get_title()
    {
        return esc_html__('EG Properties Banner', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_properties_banner_logo_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_properties_banner_content',
            [
                'label' => esc_html__('Properties Banner section', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'vernex_properties_banner_bac_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );

        $this->add_control(
            'vernex_properties_banner_bottom_button_text',
            [
                'label' => esc_html__('Button', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('All Properties', 'vernex-core'),
                'placeholder' => esc_html__('Type your button text here', 'vernex-core'),
                'label_block' => true,


            ]
        );

        $this->add_control(
            'vernex_properties_banner_bottom_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'vernex_properties_banner_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );

        $repeater->add_control(
            'vernex_properties_banner_logo_section_room_type_text',
            [
                'label' => esc_html__('Room Type', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Big Bedroom'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your room type text here', 'vernex-core'),
            ]
        );

        $repeater->add_control(
            'vernex_properties_banner_logo_section_room_size_text',
            [
                'label' => esc_html__('Room Size', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('200 Sq.m'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your room size here', 'vernex-core'),
            ]
        );


        $this->add_control(
            'vernex_properties_banner_section_list',
            [
                'label' => esc_html__(' List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'vernex_properties_banner_logo_section_room_type_text' => esc_html('Big Bedroom'),

                    ],

                ],
                'title_field' => '{{{ vernex_properties_banner_logo_section_room_type_text }}}',
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_properties_banner_text_section_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_properties_banner_text_section_style_general_room_type',
            [
                'label'     => esc_html__('Room Type', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_properties_banner_text_section_style_general_room_type_typ',
                'selector' => '{{WRAPPER}} .home2-property-banner-section .indivisual-item-list .single-item .content h6',

            ]
        );

        $this->add_control(
            'vernex_properties_banner_text_section_style_general_room_type_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-banner-section .indivisual-item-list .single-item .content h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_properties_banner_text_section_style_general_room_size',
            [
                'label'     => esc_html__('Room Size', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_properties_banner_text_section_style_general_room_size_typ',
                'selector' => '{{WRAPPER}} .home2-property-banner-section .indivisual-item-list .single-item .content span',

            ]
        );

        $this->add_control(
            'vernex_properties_banner_text_section_style_general_room_size_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-property-banner-section .indivisual-item-list .single-item .content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $data = $settings['vernex_properties_banner_section_list'];
?>

        <div class="home2-property-banner-section" <?php if (!empty($settings['vernex_properties_banner_bac_image']['url'])) { ?> style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, rgba(0, 0, 0, 0.3) 100%),url(<?php echo esc_url($settings['vernex_properties_banner_bac_image']['url']) ?>)" <?php } else { ?> style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/img/home2/home2-property-banner-bg.jpg);" <?php } ?>>
            <ul class="indivisual-item-list">
                <?php foreach ($data as $item) : ?>
                    <li class="single-item">
                        <?php if (!empty($item['vernex_properties_banner_image']['url'])) : ?>
                            <div class="img">
                                <img src="<?php echo esc_url($item['vernex_properties_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                            </div>
                        <?php endif; ?>
                        <div class="content">
                            <?php if (!empty($item['vernex_properties_banner_logo_section_room_type_text'])) : ?>
                                <h6><?php echo esc_html($item['vernex_properties_banner_logo_section_room_type_text']); ?></h6>
                            <?php endif; ?>
                            <?php if (!empty($item['vernex_properties_banner_logo_section_room_size_text'])) : ?>
                                <span><?php echo esc_html($item['vernex_properties_banner_logo_section_room_size_text']); ?></span>
                            <?php endif; ?>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
            <?php if (!empty($settings['vernex_properties_banner_bottom_button_text'])) : ?>
                <a href="<?php echo esc_url($settings['vernex_properties_banner_bottom_button_url']['url']); ?>" class="primary-btn2 white-bg">
                    <span>
                        <?php echo esc_html($settings['vernex_properties_banner_bottom_button_text']); ?>
                        <svg viewBox="0 0 13 20">
                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                        </svg>
                    </span>
                </a>
            <?php endif; ?>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Properties_Banner_Widget());
