<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Logo_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_logo';
    }

    public function get_title()
    {
        return esc_html__('EG Logo', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_scroll_logo_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_scroll_logo_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        // accordion title
        $this->add_control(
            'vernex_scroll_logo_section_genaral_header_text',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('A partner, Not A Vendor:'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        // Repeater
        $scroll_one = new \Elementor\Repeater();

        $scroll_one->add_control(
            'vernex_scroll_text_section_genaral_logo',
            [
                'label' => esc_html__('Logo', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $scroll_one->add_control(
            'vernex_scroll_text_section_genaral_logo_url',
            [
                'label' => esc_html__('Logo URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_genaral_logo_list',
            [
                'label' => esc_html__('Logo List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $scroll_one->get_controls(),
                'default' => [
                    [
                        'vernex_scroll_text_section_genaral_logo' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'vernex_scroll_text_section_genaral_logo' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_scroll_text_section_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_scroll_text_section_style_general_title_typ',
                'selector' => '{{WRAPPER}} .logo-section .logo-wrap .logo-title h6',

            ]
        );

        $this->add_control(
            'vernex_scroll_text_section_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo-section .logo-wrap .logo-title h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $running_logos = $settings['vernex_scroll_text_section_genaral_logo_list'];
?>


        <div class="logo-section <?php if ($settings['vernex_scroll_logo_section_genaral_style_selection'] == 'style_two') : ?>style-3<?php endif; ?>
            <?php if ($settings['vernex_scroll_logo_section_genaral_style_selection'] == 'style_three') : ?>style-4<?php endif; ?>">
            <div class="container-fluid">
                <div class="logo-wrap">
                    <?php if (!empty($settings['vernex_scroll_logo_section_genaral_header_text'])) : ?>
                        <div class="logo-title">
                            <h6><?php echo esc_html($settings['vernex_scroll_logo_section_genaral_header_text']); ?></h6>
                        </div>
                    <?php endif; ?>
                    <div class="marquee">
                        <div class="marquee__group">
                            <?php foreach ($running_logos as $logo) : ?>
                                <a href="<?php echo esc_url($logo['vernex_scroll_text_section_genaral_logo_url']['url']); ?>"><img src="<?php echo esc_url($logo['vernex_scroll_text_section_genaral_logo']['url']); ?>" alt=""></a>
                            <?php endforeach; ?>
                        </div>
                        <div aria-hidden="true" class="marquee__group">
                            <?php foreach ($running_logos as $logo) : ?>
                                <a href="<?php echo esc_url($logo['vernex_scroll_text_section_genaral_logo_url']['url']); ?>"><img src="<?php echo esc_url($logo['vernex_scroll_text_section_genaral_logo']['url']); ?>" alt=""></a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Logo_Widget());
