<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly

use Elementor\core\Schemes;

class Vernex_Instagram_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_instagram';
    }

    public function get_title()
    {
        return esc_html__('EG Instagram', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_instagram_instagram',
            [
                'label' => esc_html__('Instagram', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_instagram_instagram_style_switcher',
            [
                'label' => esc_html__("Style Change ?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'vernex_instagram_title',
            [
                'label'       => esc_html__('Instagram Heading', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('INSTAGRAM', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_instagram_token',
            [
                'label'       => esc_html__('Instagram access token', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'rows'        => 6,
                'placeholder' => esc_html__('Enter your instagram valid access token', 'vernex-core'),
            ]
        );

        $this->add_control(
            'vernex_instagram_limit',
            [
                'label'   => esc_html__('Instagram post showing limit', 'vernex-core'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 20,
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $accessToken = $settings['vernex_instagram_token'];
        $endpoint = "https://graph.instagram.com/me/media?fields=id,media_type,media_url,thumbnail_url,caption&access_token=$accessToken";

        // Fetch Data
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($response, true);
        $images = $data['data'] ?? [];

?>

        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".gallery-slider", {
                    speed: 1500,
                    spaceBetween: 0,
                    autoplay: {
                        delay: 2500, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },

                    breakpoints: {
                        280: {
                            slidesPerView: 2,
                        },
                        386: {
                            slidesPerView: 2,
                        },
                        576: {
                            slidesPerView: 3,
                        },
                        768: {
                            slidesPerView: 3,
                        },
                        992: {
                            slidesPerView: 4,
                        },
                        1200: {
                            slidesPerView: 5,
                        },
                        1400: {
                            slidesPerView: 5,
                        },
                    },
                });
            </script>
        <?php endif; ?>

        <div class="gallery-section <?php if ($settings['vernex_instagram_instagram_style_switcher'] == 'yes') : ?>two<?php endif; ?>">
            <div class="container">
                <div class="row mb-50">
                    <div class="col-lg-12">
                        <?php if (!empty($settings['vernex_instagram_title'])): ?>
                            <div class="title-area">
                                <h4><?php echo esc_html($settings['vernex_instagram_title']); ?></h4>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="swiper gallery-slider">
                <div class="swiper-wrapper">
                    <?php foreach ($images as $image): ?>
                        <?php if ($image['media_type'] === 'IMAGE' || $image['media_type'] === 'CAROUSEL_ALBUM'): ?>
                            <div class="swiper-slide">
                                <div class="single-gallery-img">
                                    <div class="icon-area">
                                        <a href="https://www.instagram.com/"><i class='bx bxl-instagram'></i></a>
                                    </div>
                                    <img src="<?= htmlspecialchars($image['media_url']); ?>" alt="<?= htmlspecialchars($image['caption'] ?? ''); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Instagram_Widget());
