<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Hero_Banner_Two_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_hero_banner_two';
    }

    public function get_title()
    {
        return esc_html__('EG Hero Banner Two', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_hero_banner_two_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Dreams With Precision.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Start A Project', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_button_two_text',
            [
                'label'       => esc_html__('Button Two Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('See Success Story', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_button_two_text_url',
            [
                'label' => esc_html__('Button Video URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_scroll_text_area',
            [
                'label'     => esc_html__('Scroll Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_scroll_text_one',
            [
                'label'       => esc_html__('Scroll Text One', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Quality Construction, Timely Delivery', 'vernex-core'),
                'placeholder' => esc_html__('write your scroll text here', 'vernex-core'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'vernex_hero_banner_two_section_genaral_scroll_text_two',
            [
                'label'       => esc_html__('Scroll Text Two', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Quality Construction, Timely Delivery,', 'vernex-core'),
                'placeholder' => esc_html__('write your scroll text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_section_genaral_background_image',
            [
                'label' => esc_html__('Background Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_hero_banner_two_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_two_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home2-banner-section .banner-content-wrap .banner-content h1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-banner-section .banner-content-wrap .banner-content h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_two_style_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn.white',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_bg_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_bg_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_bg_underline_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn.white' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_two',
            [
                'label'     => esc_html__('Button Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_two_style_general_button_two_typ',
                'selector' => '{{WRAPPER}} .home2-banner-section .banner-content-wrap .banner-content .btn-and-video-area .video-area h6',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-banner-section .banner-content-wrap .banner-content .btn-and-video-area .video-area h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_two_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-banner-section .banner-content-wrap .banner-content .btn-and-video-area .video-area .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_button_two_icon_color_after',
            [
                'label'     => esc_html__('Icon Color Two', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-banner-section .banner-content-wrap .banner-content .btn-and-video-area .video-area .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_scroll_text',
            [
                'label'     => esc_html__('Scroll Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_two_style_general_scroll_text_typ',
                'selector' => '{{WRAPPER}} .home2-banner-section .scroll-text-area .scroll-text h2',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_two_style_general_scroll_text_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-banner-section .scroll-text-area .scroll-text h2' => '-webkit-text-stroke: 1px {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();

?>

        <div class="home2-banner-section" <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_background_image']['url'])) : ?> style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, rgba(0, 0, 0, 0.3) 100%), url(<?php echo esc_url($settings['vernex_hero_banner_two_section_genaral_background_image']['url']); ?>);" <?php endif; ?>>
            <div class="container">
                <div class="banner-content-wrap">
                    <div class="row justify-content-center wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xl-8 col-lg-10">
                            <div class="banner-content">
                                <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_title'])) : ?>
                                    <h1><?php echo esc_html($settings['vernex_hero_banner_two_section_genaral_title']); ?></h1>
                                <?php endif; ?>
                                <div class="btn-and-video-area">
                                    <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_button_text'])) : ?>
                                        <a href="<?php echo esc_url($settings['vernex_hero_banner_two_section_genaral_button_url']['url']); ?>" class="primary-btn white">
                                            <?php echo esc_html($settings['vernex_hero_banner_two_section_genaral_button_text']); ?>
                                            <svg viewBox="0 0 13 20">
                                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                            </svg>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_button_two_text'])) : ?>
                                        <a data-fancybox="video-player"
                                            href="<?php echo esc_url($settings['vernex_hero_banner_two_section_genaral_button_two_text_url']['url']); ?>"
                                            class="video-area">
                                            <div class="icon">
                                                <svg class="video-circle" xmlns="http://www.w3.org/2000/svg"
                                                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="43px"
                                                    viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;"
                                                    xml:space="preserve">
                                                    <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100">
                                                    </circle>
                                                    <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                        d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                                    <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                                        d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53">
                                                    </path>
                                                </svg>
                                                <svg class="play-icon" width="14" height="16" viewBox="0 0 14 16"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M13.5094 7.92211C13.5094 7.49123 13.2874 7.0944 12.9152 6.86L2.86754 0.538727C2.46113 0.283462 1.96552 0.264813 1.54009 0.490029C1.11599 0.71512 0.862305 1.13058 0.862305 1.60098V14.2425C0.862305 14.7129 1.11597 15.1282 1.54074 15.3535C1.73875 15.4579 1.95113 15.5098 2.16354 15.5098C2.40776 15.5098 2.65036 15.4409 2.8674 15.3048L12.9151 8.98449C13.2874 8.74995 13.5094 8.35313 13.5094 7.92225V7.92211ZM12.5525 8.43653L2.50484 14.7568C2.30763 14.8806 2.06741 14.889 1.86141 14.7808C1.65541 14.6717 1.53211 14.4706 1.53211 14.2424V1.60086C1.53211 1.37266 1.65541 1.17074 1.86141 1.06249C1.95768 1.01224 2.06102 0.986728 2.16368 0.986728C2.2822 0.986728 2.39991 1.02001 2.50498 1.08658L12.5526 7.40785C12.7356 7.52311 12.8405 7.71116 12.8405 7.92304C12.8404 8.13414 12.7355 8.32129 12.5525 8.43653Z" />
                                                </svg>
                                            </div>
                                            <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_button_two_text'])) : ?>
                                                <h6><?php echo esc_html($settings['vernex_hero_banner_two_section_genaral_button_two_text']); ?></h6>
                                            <?php endif; ?>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="scroll-text-area">
                <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_scroll_text_one'])) : ?>
                    <div class="scroll-text">
                        <h2><?php echo esc_html($settings['vernex_hero_banner_two_section_genaral_scroll_text_one']); ?></h2>
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_hero_banner_two_section_genaral_scroll_text_two'])) : ?>
                    <div aria-hidden="true" class="scroll-text">
                        <h2><?php echo esc_html($settings['vernex_hero_banner_two_section_genaral_scroll_text_two']); ?></h2>
                    </div>
                <?php endif; ?>
            </div>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Hero_Banner_Two_Widget());
