<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Hero_Banner_Three_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_hero_banner_three';
    }

    public function get_title()
    {
        return esc_html__('EG Hero Banner Three', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_hero_banner_three_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Dreams with Precision.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Start A Project', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_banner_logo',
            [
                'label' => esc_html__('Banner Logo', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_social_area',
            [
                'label'     => esc_html__('Social Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $social_repeater = new \Elementor\Repeater();

        $social_repeater->add_control(
            'vernex_hero_banner_three_section_genaral_social_area_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $social_repeater->add_control(
            'vernex_hero_banner_three_section_genaral_social_area_icon_link',
            [
                'label'     => esc_html__('Social Url', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::URL,
                'options'   => ['url', 'is_external', 'nofollow'],
                'default'   => [
                    'url'         => '#',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_social_area_social_list',
            [
                'label'     => esc_html__('Social List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $social_repeater->get_controls(),
                'default'   => [
                    [
                        'vernex_hero_banner_three_section_genaral_social_area_icon' => [
                            'value'   => 'bx bxl-facebook',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'vernex_hero_banner_three_section_genaral_social_area_icon' => [
                            'value'   => 'bi bi-twitter-x',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'vernex_hero_banner_three_section_genaral_social_area_icon' => [
                            'value'   => 'bx bxl-pinterest-alt',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'vernex_hero_banner_three_section_genaral_social_area_icon' => [
                            'value'   => 'bx bxl-instagram',
                            'library' => 'solid',
                        ],
                    ],
                ],
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_hero_banner_three_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_three_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home3-banner-section .banner-wrapper .banner-content-and-logo .banner-content h1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner-section .banner-wrapper .banner-content-and-logo .banner-content h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_three_style_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_button_background_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_button_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_button_border_underline_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_social_area',
            [
                'label'     => esc_html__('Social Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_three_style_general_social_area_typ',
                'selector' => '{{WRAPPER}} .home3-banner-section .social-list li a',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_social_area_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner-section .social-list li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_social_area_icon_hover_color',
            [
                'label'     => esc_html__('Hover Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner-section .social-list li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_social_card',
            [
                'label'     => esc_html__('Social Card Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_style_general_social_card_bg',
            [
                'label'     => esc_html__('Background', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner-section .social-list' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $social_list = $settings['vernex_hero_banner_three_section_genaral_social_area_social_list'];
?>
        <div class="home3-banner-section">
            <ul class="social-list">
                <?php foreach ($social_list as $social) : ?>
                    <?php if (!empty($social['vernex_hero_banner_three_section_genaral_social_area_icon'])) : ?>
                        <li><a href="<?php echo esc_url($social['vernex_hero_banner_three_section_genaral_social_area_icon_link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social['vernex_hero_banner_three_section_genaral_social_area_icon']); ?></a></li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>

            <div class="banner-wrapper">
                <div class="banner-content-and-logo">
                    <div class="banner-content wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <?php if (!empty($settings['vernex_hero_banner_three_section_genaral_title'])) : ?>
                            <h1><?php echo esc_html($settings['vernex_hero_banner_three_section_genaral_title']); ?></h1>
                        <?php endif; ?>
                        <?php if (!empty($settings['vernex_hero_banner_three_section_genaral_button_text'])) : ?>
                            <a href="<?php echo esc_url($settings['vernex_hero_banner_three_section_genaral_button_url']['url']); ?>" class="primary-btn2">
                                <span>
                                    <?php echo esc_html($settings['vernex_hero_banner_three_section_genaral_button_text']); ?>
                                    <svg viewBox="0 0 13 20">
                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                    </svg>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty($settings['vernex_hero_banner_three_section_genaral_banner_logo']['url'])) : ?>
                        <div class="banner-logo btn_wrapper">
                            <img src="<?php echo esc_url($settings['vernex_hero_banner_three_section_genaral_banner_logo']['url']); ?>" alt="<?php echo esc_attr__('banner-logo', 'vernex-core'); ?>">
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Hero_Banner_Three_Widget());
