<?php

namespace Elementor;

use Egns\Helper\Egns_Helper;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Hero_Banner_Six_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_hero_banner_six';
    }

    public function get_title()
    {
        return esc_html__('EG Hero Banner Six', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_hero_banner_six_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Vision', 'vernex-core'),
                'placeholder' => esc_html__('write your subtitle here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Your Dreams with Precision.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Start A Project', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_button_two_text',
            [
                'label'       => esc_html__('Button Two Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('See Success Story', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_button_two_text_url',
            [
                'label' => esc_html__('Button Video URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=MLpWrANjFbI&ab_channel=eidelchteinadvogados',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button_area',
            [
                'label'     => esc_html__('Scroll Button Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_section_genaral_scroll_button_text',
            [
                'label'       => esc_html__('Button Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('SCROLL DOWN', 'vernex-core'),
                'placeholder' => esc_html__('write your button text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_query_area',
            [
                'label'     => esc_html__('Query Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_query_area_banner_image',
            [
                'label' => esc_html__('Banner Image Default', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->add_control(
            'nexaq_case_study_query_post_per_page',
            [
                'label'       => esc_html__('Posts Per Page', 'vernex-core'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 3,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'selected_case_study',
            [
                'label'       => __('Select Projects', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple'    => true,
                'options'     => Egns_Helper::get_projects_post_option(),
            ]
        );

        $this->add_control(
            'nexaq_case_study_query_orderby',
            [
                'label'   => esc_html__('Order By', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ID',
                'options' => [
                    'ID'         => esc_html__('Post Id', 'vernex-core'),
                    'author'     => esc_html__('Post Author', 'vernex-core'),
                    'title'      => esc_html__('Title', 'vernex-core'),
                    'post_date'  => esc_html__('Date', 'vernex-core'),
                    'rand'       => esc_html__('Random', 'vernex-core'),
                    'menu_order' => esc_html__('Menu Order', 'vernex-core'),
                ],
            ]
        );

        $this->add_control(
            'nexaq_case_study_query_template_order',
            [
                'label'   => esc_html__('Order', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'asc'  => esc_html__('Ascending', 'vernex-core'),
                    'desc' => esc_html__('Descending', 'vernex-core')

                ],
                'default' => 'desc',
            ]
        );

        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_hero_banner_six_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_title_rtyp',
                'selector' => '{{WRAPPER}} .home6-banner-section .banner-content > span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home6-banner-section .banner-content h1',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_title4_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one',
            [
                'label'     => esc_html__('Button One', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_button_one_typ',
                'selector' => '{{WRAPPER}} .primary-btn3 span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one_after_icon_color',
            [
                'label'     => esc_html__('After Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one_hover_border_color',
            [
                'label'     => esc_html__('Hover Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_one_underline_color',
            [
                'label'     => esc_html__('Underline Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn3 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_two',
            [
                'label'     => esc_html__('Button Two', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_button_two_typ',
                'selector' => '{{WRAPPER}} .home6-banner-section .banner-content .button-area .video-area h6',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_two_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .button-area .video-area h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_two_video_icon_one_color',
            [
                'label'     => esc_html__('Video Icon One Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .button-area .video-area .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_button_two_video_icon_two_color',
            [
                'label'     => esc_html__('Video Icon Two Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .button-area .video-area .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button',
            [
                'label'     => esc_html__('Scroll Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_scroll_button_typ',
                'selector' => '{{WRAPPER}} .home6-banner-section .banner-content .scroll-down-area .scroll-down-btn span',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .scroll-down-area .scroll-down-btn span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button_dicon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .scroll-down-area .scroll-down-btn .scroll-down-icon svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .scroll-down-area .scroll-down-btn .scroll-down-icon svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button_hover_icon_color',
            [
                'label'     => esc_html__('Hover Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .scroll-down-area .scroll-down-btn:hover .scroll-down-icon svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_scroll_button_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-content .scroll-down-area .scroll-down-btn .scroll-down-icon' => 'border: 1px solid {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_hero_banner_six_style_general_project_title',
            [
                'label'     => esc_html__('Project Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_project_title_typ',
                'selector' => '{{WRAPPER}} .home6-banner-section .banner-card .card-content .catgory-and-title h2 a',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_project_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-card .card-content .catgory-and-title h2 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_project_category',
            [
                'label'     => esc_html__('Project Category', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_hero_banner_six_style_general_project_category_typ',
                'selector' => '{{WRAPPER}} .home6-banner-section .banner-card .card-content .catgory-and-title > a',

            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_project_category_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-card .card-content .catgory-and-title > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_six_style_general_project_category_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home6-banner-section .banner-card .card-content .catgory-and-title > a' => 'border: 1px solid  {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();

        $selected_post_ids     = $settings['selected_case_study'];

        $args = array(
            'post_type'      => 'project',
            'posts_per_page' => $settings['nexaq_case_study_query_post_per_page'],
            'orderby'        => $settings['nexaq_case_study_query_orderby'],
            'order'          => $settings['nexaq_case_study_query_template_order'],
            'offset'         => 0,
            'post_status'    => 'publish',
        );
        if (!empty($selected_post_ids)) {
            $args['post__in'] = $selected_post_ids;
        }
        $query = new \WP_Query($args);
?>

        <?php if (is_admin()) : ?>
            <script>
                var swiper = new Swiper(".home6-banner-slider", {
                    slidesPerView: 1,
                    speed: 1500,
                    spaceBetween: 0,
                    autoplay: {
                        delay: 3000, // Autoplay duration in milliseconds
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: ".next-1",
                        prevEl: ".prev-1",
                    },

                    breakpoints: {
                        280: {
                            slidesPerView: 1,
                        },
                        386: {
                            slidesPerView: 1,
                        },
                        576: {
                            slidesPerView: 2,
                        },
                        768: {
                            slidesPerView: 2,
                        },
                        992: {
                            slidesPerView: 2,
                        },
                        1200: {
                            slidesPerView: 2,
                        },
                        1400: {
                            slidesPerView: 2,
                        },
                    }
                });

                jQuery(".banner-hover").on("mouseenter", function() { // Changes the .image-holder's img src to the src defined in .list a's data attribute.
                    var value = $(this).attr('data-src');
                    document.getElementById("home6-banner-bg").style.background = "linear-gradient(180deg, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.5) 100%) ,url('" + value + "')";
                });
            </script>
        <?php endif; ?>

        <div class="home6-banner-section">
            <div class="row">
                <div class="col-xl-5">
                    <div class="banner-content">
                        <?php if (!empty($settings['vernex_hero_banner_six_section_genaral_subtitle'])) : ?>
                            <span><?php echo esc_html($settings['vernex_hero_banner_six_section_genaral_subtitle']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['vernex_hero_banner_six_section_genaral_title'])) : ?>
                            <h1><?php echo esc_html($settings['vernex_hero_banner_six_section_genaral_title']); ?></h1>
                        <?php endif; ?>
                        <div class="button-area">
                            <?php if (!empty($settings['vernex_hero_banner_six_section_genaral_button_text'])) : ?>
                                <a href="<?php echo esc_url($settings['vernex_hero_banner_six_section_genaral_button_url']['url']); ?>" class="primary-btn3">
                                    <span>
                                        <?php echo esc_html($settings['vernex_hero_banner_six_section_genaral_button_text']); ?>
                                        <svg viewBox="0 0 13 20">
                                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                        </svg>
                                    </span>
                                    <i class="corner tl"></i>
                                    <i class="corner tr"></i>
                                    <i class="corner br"></i>
                                    <i class="corner bl"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (!empty($settings['vernex_hero_banner_six_section_genaral_button_two_text'])) : ?>
                                <a data-fancybox="video-player"
                                    href="<?php echo esc_url($settings['vernex_hero_banner_six_section_genaral_button_two_text_url']['url']); ?>"
                                    class="video-area">
                                    <div class="icon">
                                        <svg class="video-circle" xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="43px"
                                            viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;"
                                            xml:space="preserve">
                                            <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100">
                                            </circle>
                                            <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                            <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10"
                                                d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53">
                                            </path>
                                        </svg>
                                        <svg class="play-icon" width="14" height="16" viewBox="0 0 14 16"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M13.5094 7.92211C13.5094 7.49123 13.2874 7.0944 12.9152 6.86L2.86754 0.538727C2.46113 0.283462 1.96552 0.264813 1.54009 0.490029C1.11599 0.71512 0.862305 1.13058 0.862305 1.60098V14.2425C0.862305 14.7129 1.11597 15.1282 1.54074 15.3535C1.73875 15.4579 1.95113 15.5098 2.16354 15.5098C2.40776 15.5098 2.65036 15.4409 2.8674 15.3048L12.9151 8.98449C13.2874 8.74995 13.5094 8.35313 13.5094 7.92225V7.92211ZM12.5525 8.43653L2.50484 14.7568C2.30763 14.8806 2.06741 14.889 1.86141 14.7808C1.65541 14.6717 1.53211 14.4706 1.53211 14.2424V1.60086C1.53211 1.37266 1.65541 1.17074 1.86141 1.06249C1.95768 1.01224 2.06102 0.986728 2.16368 0.986728C2.2822 0.986728 2.39991 1.02001 2.50498 1.08658L12.5526 7.40785C12.7356 7.52311 12.8405 7.71116 12.8405 7.92304C12.8404 8.13414 12.7355 8.32129 12.5525 8.43653Z" />
                                        </svg>
                                    </div>
                                    <h6><?php echo esc_html($settings['vernex_hero_banner_six_section_genaral_button_two_text']); ?></h6>
                                </a>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($settings['vernex_hero_banner_six_section_genaral_scroll_button_text'])) : ?>
                            <div class="scroll-down-area" id="scroll-btn">
                                <div class="scroll-down-btn">
                                    <div class="scroll-down-icon">
                                        <svg width="17" height="26" viewBox="0 0 17 26" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M8.49961 0.399902V25.5999M8.49961 25.5999C8.94961 22.2999 11.1096 15.7899 16.1496 16.1499M8.49961 25.5999C7.59961 22.1499 4.80961 15.4299 0.849609 16.1499" />
                                        </svg>
                                    </div>
                                    <span><?php echo esc_html($settings['vernex_hero_banner_six_section_genaral_scroll_button_text']); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="banner-slider-area">
                        <div id="home6-banner-bg" style="background: linear-gradient(rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.5) 100%), url(<?php echo esc_url($settings['vernex_hero_banner_six_style_query_area_banner_image']['url']); ?>);"></div>
                        <div class="banner-wrapper">
                            <div class="swiper home6-banner-slider">
                                <div class="swiper-wrapper">
                                    <?php
                                    while ($query->have_posts()) :
                                        $query->the_post();
                                    ?>
                                        <div class="swiper-slide">
                                            <div class="banner-card banner-hover" data-src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'large'); ?>">
                                                <div class="card-content">
                                                    <div class="catgory-and-title">
                                                        <?php
                                                        $categories = get_the_terms(get_the_ID(), 'project-category');
                                                        if (!empty($categories) && !is_wp_error($categories)) {
                                                            $first_category = $categories[0];
                                                            $category_link = get_term_link($first_category);
                                                            $category_name = $first_category->name;
                                                        ?>
                                                            <a href="<?php echo esc_url($category_link); ?>"><?php echo esc_html($category_name); ?></a>
                                                        <?php
                                                        }
                                                        ?>
                                                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                    wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Hero_Banner_Six_Widget());
