<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly

use Elementor\core\Schemes;

class Vernex_Heading_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_heading';
    }

    public function get_title()
    {
        return esc_html__('EG Heading', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_heading_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_heading_content_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                    'style_five' => esc_html__('Style Five', 'vernex-core'),
                    'style_six' => esc_html__('Style Six', 'vernex-core'),
                ],
                'default' => 'style_one',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vernex_heading_genaral',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_subtitle',
            [
                'label'       => esc_html__('Sub Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Trust Since 2005', 'vernex-core'),
                'placeholder' => esc_html__('write your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Experts in Construction Your Excellence.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vernex_heading_two_genaral',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_two'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_two_subtitle',
            [
                'label'       => esc_html__('Sub Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Trust Since 2005', 'vernex-core'),
                'placeholder' => esc_html__('write your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_two_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Experts in Construction Your Excellence.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vernex_heading_three_genaral',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_three'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_three_subtitle',
            [
                'label'       => esc_html__('Sub Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Building Trust Since 2005', 'vernex-core'),
                'placeholder' => esc_html__('write your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_three_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Experts in Construction Your Excellence.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'vernex_heading_genaral_three_desc',
            [
                'label'       => esc_html__('Description', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'vernex_heading_four_genaral',
            [
                'label' => esc_html__('Heading', 'vernex-core'),
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_four'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_four_subtitle',
            [
                'label'       => esc_html__('Sub Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Our Latest Work', 'vernex-core'),
                'placeholder' => esc_html__('write your sub title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_four_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Celebrating Design Achievements.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );


        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_heading_genaral_title_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_one'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_subtitle',
            [
                'label'     => esc_html__('Sub Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_heading_genaral_title_style_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_heading_genaral_two_title_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_two'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_two_subtitle',
            [
                'label'     => esc_html__('Sub Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_two_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_two_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_heading_genaral_title_style_two_subtitle_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_two_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_two_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_two_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_heading_genaral_three_title_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_three'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_three_subtitle',
            [
                'label'     => esc_html__('Sub Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_three_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_three_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_heading_genaral_title_style_three_subtitle_bac_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_three_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_three_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_three_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_three_desc',
            [
                'label'     => esc_html__('Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_three_desc_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_desc_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_heading_genaral_four_title_style',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_heading_content_style_selection' => 'style_four'
                ]
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_four_subtitle',
            [
                'label'     => esc_html__('Sub Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_four_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_four_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vernex_heading_genaral_title_style_four_subtitle_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_four_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_heading_genaral_title_style_four_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_heading_genaral_title_style_four_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['vernex_heading_content_style_selection'] == 'style_one') : ?>
            <div class="section-title">
                <?php if (!empty($settings['vernex_heading_genaral_subtitle'])) : ?>
                    <span><?php echo esc_html($settings['vernex_heading_genaral_subtitle']); ?></span>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_heading_genaral_title'])) : ?>
                    <h2><?php echo esc_html($settings['vernex_heading_genaral_title']); ?></h2>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_heading_content_style_selection'] == 'style_two') : ?>
            <div class="section-title two text-center">
                <?php if (!empty($settings['vernex_heading_genaral_two_subtitle'])) : ?>
                    <span><?php echo esc_html($settings['vernex_heading_genaral_two_subtitle']); ?></span>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_heading_genaral_two_title'])) : ?>
                    <h2><?php echo esc_html($settings['vernex_heading_genaral_two_title']); ?></h2>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_heading_content_style_selection'] == 'style_three') : ?>
            <div class="section-title three text-center">
                <?php if (!empty($settings['vernex_heading_genaral_three_subtitle'])) : ?>
                    <span><?php echo esc_html($settings['vernex_heading_genaral_three_subtitle']); ?></span>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_heading_genaral_three_title'])) : ?>
                    <h2><?php echo esc_html($settings['vernex_heading_genaral_three_title']); ?></h2>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_heading_genaral_three_desc'])) : ?>
                    <p><?php echo esc_html($settings['vernex_heading_genaral_three_desc']); ?></p>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_heading_content_style_selection'] == 'style_four') : ?>
            <div class="section-title four">
                <?php if (!empty($settings['vernex_heading_genaral_four_subtitle'])) : ?>
                    <span><?php echo esc_html($settings['vernex_heading_genaral_four_subtitle']); ?></span>
                <?php endif; ?>
                <?php if (!empty($settings['vernex_heading_genaral_four_title'])) : ?>
                    <h2><?php echo esc_html($settings['vernex_heading_genaral_four_title']); ?></h2>
                <?php endif; ?>
            </div>
        <?php endif; ?>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Heading_Widget());
