<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Footer_Title_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_footer_title';
    }

    public function get_title()
    {
        return esc_html__('EG Footer Title', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_footer_title_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_footer_title_section_genaral_text',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();

?>

        <div class="footer-widget">
            <div class="widget-title">
                <?php if (!empty($settings['vernex_footer_title_section_genaral_text'])) : ?>
                    <h5><?php echo esc_html($settings['vernex_footer_title_section_genaral_text']); ?></h5>
                <?php endif; ?>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Footer_Title_Widget());
