<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Footer_Newsletter_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'Vernex_footer_newsletter_Widget';
    }

    public function get_title()
    {
        return esc_html__('EG Footer Newsletter', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_footer_newsletter_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_footer_newsletter_section_genaral_background_image',
            [
                'label' => esc_html__('Background Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_footer_newsletter_section_genaral_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html("Don’t Missed Subscribe Connected With Us."),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $this->add_control(
            'vernex_footer_newsletter_section_genaral_shortcode',
            [
                'label'       => esc_html__('Shortcode', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html(''),
                'placeholder' => esc_html__('Type your shortcode here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
?>

        <div class="contact-banner-area"
            style="background-image: linear-gradient(90deg, #000000 5.18%, rgba(0, 0, 0, 0.4) 100%), url('<?php echo esc_url($settings['vernex_footer_newsletter_section_genaral_background_image']['url']); ?>');">
            <?php if (!empty($settings['vernex_footer_newsletter_section_genaral_title'])) : ?>
                <h4><?php echo esc_html($settings['vernex_footer_newsletter_section_genaral_title']); ?></h4>
            <?php endif; ?>
            <?php if (!empty($settings['vernex_footer_newsletter_section_genaral_shortcode'])) : ?>
                <?php echo do_shortcode($settings['vernex_footer_newsletter_section_genaral_shortcode']); ?>
            <?php endif; ?>
        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Footer_Newsletter_Widget());
