<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Footer_Logo_And_Contact_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_footer_logo_and_contact';
    }

    public function get_title()
    {
        return esc_html__('EG Footer Logo & Contact', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_footer_logo_and_contact_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_footer_logo_and_contact_section_genaral_logo_image',
            [
                'label' => esc_html__('Logo Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_footer_logo_and_contact_section_genaral_logo_image_link',
            [
                'label'     => esc_html__('Logo Url', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::URL,
                'options'   => ['url', 'is_external', 'nofollow'],
                'default'   => [
                    'url'         => '#',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_footer_logo_and_contact_section_genaral_description',
            [
                'label' => esc_html__('Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Welcome to Vernex, where innovation meet our passion in a journey that started dream.'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $social_repeater = new \Elementor\Repeater();

        $social_repeater->add_control(
            'vernex_footer_logo_and_contact_section_genaral_social_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'bx bxl-facebook',
                    'library' => 'solid',
                ]
            ]
        );

        $social_repeater->add_control(
            'vernex_footer_logo_and_contact_section_genaral_social_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('LinkedIn'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );


        $social_repeater->add_control(
            'vernex_footer_logo_and_contact_section_genaral_social_link',
            [
                'label'     => esc_html__('Social Url', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::URL,
                'options'   => ['url', 'is_external', 'nofollow'],
                'default'   => [
                    'url'         => '#',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_footer_logo_and_contact_section_genaral_social_list',
            [
                'label'     => esc_html__('Social List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $social_repeater->get_controls(),
                'default'   => [
                    [
                        'vernex_footer_logo_and_contact_section_genaral_social_icon' => [
                            'value'   => 'bi bi-linkedin',
                            'library' => 'solid',
                        ],
                        'vernex_footer_logo_and_contact_section_genaral_social_title'    => wp_kses('LinkedIn', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_logo_and_contact_section_genaral_social_icon' => [
                            'value'   => 'bi bi-facebook',
                            'library' => 'solid',
                        ],
                        'vernex_footer_logo_and_contact_section_genaral_social_title'    => wp_kses('Facebook', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_logo_and_contact_section_genaral_social_icon' => [
                            'value'   => 'bi bi-twitter-x',
                            'library' => 'solid',
                        ],
                        'vernex_footer_logo_and_contact_section_genaral_social_title'    => wp_kses('Twitter', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_logo_and_contact_section_genaral_social_icon' => [
                            'value'   => 'bi bi-instagram',
                            'library' => 'solid',
                        ],
                        'vernex_footer_logo_and_contact_section_genaral_social_title'    => wp_kses('Instagram', wp_kses_allowed_html('post')),
                    ],
                ],
            ]
        );



        $contact_info = new \Elementor\Repeater();


        $contact_info->add_control(
            'vernex_footer_logo_and_contact_section_genaral_select_type',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'phone' => esc_html__('Phone', 'vernex-core'),
                    'email' => esc_html__('Email', 'vernex-core'),
                    'custom' => esc_html__('Custom', 'vernex-core'),

                ],
                'default' => 'phone',
            ]
        );

        $contact_info->add_control(
            'vernex_footer_logo_and_contact_section_genaral_contact_icon',
            [
                'label'     => esc_html__('Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => []
            ]
        );

        $contact_info->add_control(
            'vernex_footer_logo_and_contact_section_genaral_contact_title',
            [
                'label' => esc_html__('Contact Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('CALL ANY TIME'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $contact_info->add_control(
            'vernex_footer_logo_and_contact_section_genaral_contact_content_info',
            [
                'label' => esc_html__('Contact Info', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('2-965-871-8617'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $contact_info->add_control(
            'vernex_footer_logo_and_contact_section_genaral_contact_content_info_url',
            [
                'label' => esc_html__('Contact URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition'   => [
                    'vernex_footer_logo_and_contact_section_genaral_select_type' => ['custom'],
                ]
            ]
        );

        $this->add_control(
            'vernex_footer_logo_and_contact_section_genaral_contact_list',
            [
                'label'     => esc_html__('Contact List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $contact_info->get_controls(),
                'default'   => [
                    [
                        'vernex_footer_logo_and_contact_section_genaral_contact_title'    => wp_kses('CALL ANY TIME', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_logo_and_contact_section_genaral_contact_title'    => wp_kses('ADDRESS', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_logo_and_contact_section_genaral_contact_title'    => wp_kses('SAY HELLO', wp_kses_allowed_html('post')),
                    ],
                ],
                'title_field'    => '{{{ vernex_footer_logo_and_contact_section_genaral_contact_title }}}',
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $social_area = $settings['vernex_footer_logo_and_contact_section_genaral_social_list'];
        $contact_area = $settings['vernex_footer_logo_and_contact_section_genaral_contact_list'];
?>

        <div class="footer-logo-and-contact-area">
            <div class="footer-logo-area">
                <?php if (!empty($settings['vernex_footer_logo_and_contact_section_genaral_logo_image']['url'])) : ?>
                    <a href="<?php echo esc_url($settings['vernex_footer_logo_and_contact_section_genaral_logo_image_link']['url']); ?>" class="footer-logo">
                        <img src="<?php echo esc_url($settings['vernex_footer_logo_and_contact_section_genaral_logo_image']['url']); ?>" alt="<?php echo esc_attr__('footer-logo', 'vernex-core'); ?>">
                    </a>
                <?php endif; ?>
                <div class="footer-content">
                    <?php if (!empty($settings['vernex_footer_logo_and_contact_section_genaral_description'])) : ?>
                        <p><?php echo esc_html($settings['vernex_footer_logo_and_contact_section_genaral_description']); ?></p>
                    <?php endif; ?>

                    <ul class="social-list">
                        <?php foreach ($social_area as $social) : ?>
                            <li>
                                <a href="<?php echo esc_url($social['vernex_footer_logo_and_contact_section_genaral_social_link']['url']); ?>">
                                    <?php \Elementor\Icons_Manager::render_icon($social['vernex_footer_logo_and_contact_section_genaral_social_icon']); ?>
                                    <?php if (!empty($social['vernex_footer_logo_and_contact_section_genaral_social_title'])) : ?>
                                        <span><?php echo esc_html($social['vernex_footer_logo_and_contact_section_genaral_social_title']); ?></span>
                                    <?php endif; ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>

            <ul class="contact-area">
                <?php foreach ($contact_area as $index => $contact) : ?>
                    <li>
                        <div class="single-contact">
                            <?php if (!empty($contact['vernex_footer_logo_and_contact_section_genaral_contact_icon'])) : ?>
                                <div class="icon">
                                    <?php \Elementor\Icons_Manager::render_icon($contact['vernex_footer_logo_and_contact_section_genaral_contact_icon']); ?>
                                </div>
                            <?php endif; ?>
                            <div class="content">
                                <?php if (!empty($contact['vernex_footer_logo_and_contact_section_genaral_contact_title'])) : ?>
                                    <span><?php echo esc_html($contact['vernex_footer_logo_and_contact_section_genaral_contact_title']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($contact['vernex_footer_logo_and_contact_section_genaral_contact_content_info'])) : ?>
                                    <h6><a href="<?php if ($contact['vernex_footer_logo_and_contact_section_genaral_select_type'] == 'phone') : ?>tel:<?php echo preg_replace('/[^0-9]/', '', $contact['vernex_footer_logo_and_contact_section_genaral_contact_content_info']); ?><?php elseif ($contact['vernex_footer_logo_and_contact_section_genaral_select_type'] == 'email') : ?>mailto: <?php echo esc_html($contact['vernex_footer_logo_and_contact_section_genaral_contact_content_info']); ?><?php elseif ($contact['vernex_footer_logo_and_contact_section_genaral_select_type'] == 'custom') : ?><?php echo esc_url($contact['vernex_footer_logo_and_contact_section_genaral_contact_content_info_url']['url']); ?><?php endif; ?>"><?php echo esc_html($contact['vernex_footer_logo_and_contact_section_genaral_contact_content_info']); ?></a></h6>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if ($index !== count($contact_area) - 1) : ?>
                            <svg class="arrow" width="8" height="29" viewBox="0 0 8 29" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.33333 3C1.33333 4.47276 2.52724 5.66667 4 5.66667C5.47276 5.66667 6.66667 4.47276 6.66667 3C6.66667 1.52724 5.47276 0.333333 4 0.333333C2.52724 0.333333 1.33333 1.52724 1.33333 3ZM3.64645 28.3536C3.84171 28.5488 4.15829 28.5488 4.35355 28.3536L7.53553 25.1716C7.7308 24.9763 7.7308 24.6597 7.53553 24.4645C7.34027 24.2692 7.02369 24.2692 6.82843 24.4645L4 27.2929L1.17157 24.4645C0.976311 24.2692 0.659728 24.2692 0.464466 24.4645C0.269204 24.6597 0.269204 24.9763 0.464466 25.1716L3.64645 28.3536ZM3.5 3V28H4.5V3H3.5Z" />
                            </svg>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>

            </ul>


        </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Footer_Logo_And_Contact_Widget());
