<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Footer_Copyright_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'Vernex_Footer_Copyright_Widget';
    }

    public function get_title()
    {
        return esc_html__('EG Footer Copyright', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_copyright_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_copyright_section_genaral_copyright',
            [
                'label' => esc_html__('Copyright Text', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Copyright 2025 <a href="http://www.vernex-wp.egenstheme.com">Vernex</a> | Design By <a href="https://www.egenslab.com/">Egens Lab</a>', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
            ]
        );

        $copyright_menu = new \Elementor\Repeater();

        $copyright_menu->add_control(
            'vernex_copyright_section_genaral_menu_name',
            [
                'label' => esc_html__('Menu Item Name', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Residential'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $copyright_menu->add_control(
            'vernex_copyright_section_genaral_menu_name_url',
            [
                'label' => esc_html__('Menu Item URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_copyright_section_genaral_menu_list',
            [
                'label'     => esc_html__('Menu List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $copyright_menu->get_controls(),
                'default'   => [
                    [
                        'vernex_copyright_section_genaral_menu_name'    => wp_kses('Support Policy', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_copyright_section_genaral_menu_name'    => wp_kses('Terms & Conditions', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_copyright_section_genaral_menu_name'    => wp_kses('Privacy Policy', wp_kses_allowed_html('post')),
                    ],
                ],
                'title_field'    => '{{{ vernex_copyright_section_genaral_menu_name }}}',
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $copyright_menu = $settings['vernex_copyright_section_genaral_menu_list'];
?>

        <div class="footer-bottom">
            <?php if (!empty($settings['vernex_copyright_section_genaral_copyright'])) : ?>
                <div class="copyright-area">
                    <p><?php echo wp_kses($settings['vernex_copyright_section_genaral_copyright'], wp_kses_allowed_html('post')); ?></p>
                </div>
            <?php endif; ?>
            <div class="footer-bottom-right">

                <ul>
                    <?php foreach ($copyright_menu as $menu) : ?>
                        <?php if (!empty($menu['vernex_copyright_section_genaral_menu_name'])) : ?>
                            <li><a href="<?php echo esc_url($menu['vernex_copyright_section_genaral_menu_name_url']['url']); ?>"><?php echo esc_html($menu['vernex_copyright_section_genaral_menu_name']); ?></a></li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>

            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Footer_Copyright_Widget());
