<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Footer_Address_Area_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_footer_address_area';
    }

    public function get_title()
    {
        return esc_html__('EG Footer Address Area', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_footer_contact_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $contact_info = new \Elementor\Repeater();

        $contact_info->add_control(
            'vernex_footer_contact_section_genaral_address_title',
            [
                'label' => esc_html__('Address Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('NEW YORK'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $contact_info->add_control(
            'vernex_footer_contact_section_genaral_address_info',
            [
                'label' => esc_html__('Address Info', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('8204 Glen Ridge DriveEndicott, NY 13760'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),

            ]
        );

        $contact_info->add_control(
            'vernex_footer_contact_section_genaral_address_info_url',
            [
                'label' => esc_html__('Address URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_footer_contact_section_genaral_address_list',
            [
                'label'     => esc_html__('Address List', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $contact_info->get_controls(),
                'default'   => [
                    [
                        'vernex_footer_contact_section_genaral_address_title'    => wp_kses('NEW YORK', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_contact_section_genaral_address_title'    => wp_kses('WASHINGTON DC', wp_kses_allowed_html('post')),
                    ],
                    [
                        'vernex_footer_contact_section_genaral_address_title'    => wp_kses('NEW JERSEY', wp_kses_allowed_html('post')),
                    ],
                ],
                'title_field'    => '{{{ vernex_footer_contact_section_genaral_address_title }}}',
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $address_area = $settings['vernex_footer_contact_section_genaral_address_list'];

?>
        <ul class="address-area">
            <?php foreach ($address_area as $address) : ?>
                <li class="single-address">
                    <?php if (!empty($address['vernex_footer_contact_section_genaral_address_title'])) : ?>
                        <span><?php echo esc_html($address['vernex_footer_contact_section_genaral_address_title']); ?></span>
                    <?php endif; ?>
                    <?php if (!empty($address['vernex_footer_contact_section_genaral_address_info'])) : ?>
                        <a href="<?php echo esc_url($address['vernex_footer_contact_section_genaral_address_info_url']['url']); ?>"><?php echo esc_html($address['vernex_footer_contact_section_genaral_address_info']); ?></a>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ul>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Footer_Address_Area_Widget());
