<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Feature_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_feature';
    }

    public function get_title()
    {
        return esc_html__('EG Feature', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_feature_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_feature_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Your subtitle', 'vernex-core'),
                'placeholder' => esc_html__('Write your subtitle here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_feature_section_genaral_title',
            [
                'label'       => esc_html__('Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Real Estate Agent Of The Year.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_feature_section_genaral_p_text',
            [
                'label'       => esc_html__('Paragraph', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero, sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse nectoraba porttitor velit go this week and more about.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_feature_section_genaral_video',
            [
                'label'       => esc_html__('Video', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::URL,
                'default'     => [
                    'url'     => esc_html__('Your video link', 'vernex-core'),
                ]
            ]
        );

        $this->add_control(
            'vernex_feature_list_main_title',
            [
                'label'       => esc_html__('Feature List Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('VERNEX PLATFORM.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_feature_list_sub_title',
            [
                'label'       => esc_html__('Feature List Sub-itle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Feature.', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $feature_list = new \Elementor\Repeater();

        $feature_list->add_control(
            'vernex_feature_list_item_title',
            [
                'label'       => esc_html__('Item Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Create engaging content', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $feature_list->add_control(
            'vernex_feature_item_text',
            [
                'label'       => esc_html__('Item Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Eye-catching visual, informative caption, & interactive elements can all help you capture attention and stop the scroll.', 'vernex-core'),
                'placeholder' => esc_html__('write your title here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'vernex_feature_item_repeater',
            [
                'label'       => esc_html__('Feature List', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $feature_list->get_controls(),
                'default'     => [
                    [
                        'vernex_feature_list_item_title'   => esc_html__('Create engaging content:', 'vernex-core'),
                        'vernex_feature_list_item_text'    => esc_html__('Eye-catching visual, informative caption, & interactive elements can all help you capture attention and stop the scroll.', 'vernex-core')
                    ],
                    [
                        'vernex_feature_list_item_title'   => esc_html__('Plan and schedule posts:', 'vernex-core'),
                        'vernex_feature_list_item_text'    => esc_html__('Schedule your content advance to ensure consistent presence and maintain a steady flow of communication.', 'vernex-core')
                    ]
                ],
                'title_field'   => '{{{ vernex_feature_list_item_title }}}'
            ]
        );

        $this->add_control(
            'vernex_feature_section_main_image',
            [
                'label'     => esc_html__('Feature section image', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => \Elementor\Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $this->end_controls_section();

        // style start
        $this->start_controls_section(
            'vernex_feature_style_one_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_feature_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.two span',

            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'name'      => 'vernex_feature_style_general_subtitle_bg',
                'selector' => '{{WRAPPER}} .section-title.two span',
            ]
        );

        $this->add_control(
            'vernex_feature_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.two span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_feature_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_feature_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_feature_section_genaral_p_text_style',
            [
                'label'     => esc_html__('Feature Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_section_genaral_p_text_style_typ',
                'selector' => '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .video-and-content .content p',

            ]
        );

        $this->add_control(
            'vernex_feature_section_genaral_p_text_style_color',
            [
                'label'     => esc_html__('Text Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .video-and-content .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_feature_list_style_general_title',
            [
                'label'     => esc_html__('List Section Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_list_style_general_title_typ',
                'selector' => '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list h6',

            ]
        );

        $this->add_control(
            'vernex_feature_list_style_general_title_color',
            [
                'label'     => esc_html__('Title Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_feature_list_style_general_subtitle',
            [
                'label'     => esc_html__('List section subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_list_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list h6 span',

            ]
        );

        $this->add_control(
            'vernex_feature_list_style_general_subtitle_color',
            [
                'label'     => esc_html__('Subtitle Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list h6 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_feature_list_item_style_title',
            [
                'label'     => esc_html__('List Item Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_list_item_style_title_typ',
                'selector' => '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list ul li strong',

            ]
        );

        $this->add_control(
            'vernex_feature_list_item_style_title_color',
            [
                'label'     => esc_html__('Title Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list ul li strong' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_feature_list_item_style_text',
            [
                'label'     => esc_html__('List Item Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_feature_list_item_style_text_typ',
                'selector' => '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list ul li',

            ]
        );

        $this->add_control(
            'vernex_feature_list_item_style_text_color',
            [
                'label'     => esc_html__('Text Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-feature-section .feature-content-wrap .feature-content .feature-list ul li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $feature_list = $settings['vernex_feature_item_repeater'];
?>

        <div class="home2-feature-section">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="feature-content-wrap">
                            <div class="section-title two">
                                <?php if (!empty($settings['vernex_feature_section_genaral_subtitle'])): ?>
                                    <span><?php echo esc_html($settings['vernex_feature_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <h2><?php echo esc_html($settings['vernex_feature_section_genaral_title']); ?></h2>
                            </div>
                            <div class="feature-content">
                                <div class="video-and-content">
                                    <a data-fancybox="video-player"
                                        href="<?php echo esc_url($settings['vernex_feature_section_genaral_video']['url']); ?>"
                                        class="video-area">
                                        <div class="icon">
                                            <svg class="video-circle" xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="77px"
                                                viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;"
                                                xml:space="preserve">
                                                <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100">
                                                </circle>
                                                <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10"
                                                    d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                                <path class="circle-half bottom-half" stroke-width="4"
                                                    stroke-miterlimit="10"
                                                    d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53">
                                                </path>
                                            </svg>
                                            <svg class="play-icon" width="23" height="28" viewBox="0 0 23 28"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M22.8424 14.2559C22.8424 13.4843 22.4449 12.7737 21.7784 12.3539L3.78608 1.03446C3.05833 0.577358 2.17083 0.543963 1.40902 0.947257C0.649591 1.35033 0.195312 2.09429 0.195312 2.93663V25.5738C0.195312 26.4162 0.649555 27.1599 1.41018 27.5632C1.76475 27.7501 2.14507 27.8431 2.52543 27.8431C2.96275 27.8431 3.39718 27.7197 3.78584 27.476L21.7782 16.1583C22.4449 15.7383 22.8424 15.0277 22.8424 14.2561V14.2559ZM21.1289 15.177L3.13659 26.4947C2.78345 26.7165 2.35329 26.7315 1.98441 26.5376C1.61553 26.3424 1.39473 25.9822 1.39473 25.5736V2.93642C1.39473 2.52778 1.61553 2.16621 1.98441 1.97237C2.15681 1.88239 2.34185 1.83669 2.52569 1.83669C2.73791 1.83669 2.9487 1.8963 3.13685 2.0155L21.1292 13.335C21.4568 13.5414 21.6447 13.8781 21.6447 14.2575C21.6444 14.6356 21.4565 14.9707 21.1289 15.177Z" />
                                            </svg>
                                        </div>
                                    </a>
                                    <div class="content">
                                        <p><?php echo $settings['vernex_feature_section_genaral_p_text']; ?></p>
                                    </div>
                                </div>
                                <div class="feature-list">
                                    <h6><?php echo esc_html($settings['vernex_feature_list_main_title']); ?> <span><?php echo esc_html($settings['vernex_feature_list_sub_title']); ?></span></h6>
                                    <ul>
                                        <?php foreach ($feature_list as $feature_list_item): ?>
                                            <li><strong><?php echo esc_html($feature_list_item['vernex_feature_list_item_title']); ?></strong> <?php echo esc_html($feature_list_item['vernex_feature_list_item_text']); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 d-lg-block d-none wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="magnetic-wrap">
                            <div class="feature-img magnetic-item">
                                <img src="<?php echo esc_url($settings['vernex_feature_section_main_image']['url']); ?>" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Feature_Widget());
