<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Faq_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_faq';
    }

    public function get_title()
    {
        return esc_html__('EG FAQ', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_faql_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),

                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_header_subtitle',
            [
                'label' => esc_html__('Subtitle', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Cassian Coleson'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your subtitle here', 'vernex-core'),
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => ['style_three'],
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_header_title',
            [
                'label' => esc_html__('Header Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses('Question <br> Answer', wp_kses_allowed_html('post')),
                'label_block' => true,
                'placeholder' => esc_html__('Type your title here', 'vernex-core'),
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => ['style_two', 'style_three', 'style_four'],
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_show_right_side_content',
            [
                'label' => esc_html__("Show Right Side Content?", 'vernex-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vernex-core'),
                'label_off' => esc_html__('No', 'vernex-core'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );

        //faq_list

        $faq_one = new \Elementor\Repeater();

        // accordion title
        $faq_one->add_control(
            'vernex_faq_section_genaral_question',
            [
                'label' => esc_html__('Question', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Cassian Coleson'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your question here', 'vernex-core'),
            ]
        );

        // accordion Description
        $faq_one->add_control(
            'vernex_faq_section_genaral_answer',
            [
                'label' => esc_html__('Answer', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Founder at, Nexaq'),
                'placeholder' => esc_html__('Type your answer here', 'vernex-core'),
            ]
        );


        $this->add_control(
            'vernex_faq_section_genaral_faq_list',
            [
                'label' => esc_html__('FAQ List', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $faq_one->get_controls(),
                'default' => [
                    [
                        'vernex_faq_section_genaral_question' => esc_html('01. Do you provide design and architectural services?'),
                        'vernex_faq_section_genaral_answer' => esc_html('Yes, we offer comprehensive design and architectural services to meet your construction needs, ensuring a seamless process from concept to completion.'),

                    ],
                    [
                        'vernex_faq_section_genaral_question' => esc_html('02. Is Vernex suitable for my business?'),
                        'vernex_faq_section_genaral_answer' => esc_html('Discover if Vernex is the right fit for your business by exploring its tailored solutions for various industries and unique needs.'),

                    ],
                    [
                        'vernex_faq_section_genaral_question' => esc_html('03. What is your typical project timeline?'),
                        'vernex_faq_section_genaral_answer' => esc_html('Discover the typical project timeline for our construction services, outlining each phase from planning to completion, ensuring timely and efficient project delivery.'),

                    ],
                    [
                        'vernex_faq_section_genaral_question' => esc_html('04. How do you handle permits and inspections?'),
                        'vernex_faq_section_genaral_answer' => esc_html('We handle all necessary permits and inspections for your project, ensuring full compliance with local regulations and smooth progress throughout the construction process.'),

                    ],
                    [
                        'vernex_faq_section_genaral_question' => esc_html('05. How do you handle waste disposal and recycling?'),
                        'vernex_faq_section_genaral_answer' => esc_html('At our construction sites, we prioritize responsible waste disposal and recycling by adhering to local regulations, implementing sustainable practices, and partnering with certified waste management services to minimize environmental impact.'),

                    ],
                    [
                        'vernex_faq_section_genaral_question' => esc_html('06. How do ensure buildings are structurally safe?'),
                        'vernex_faq_section_genaral_answer' => esc_html('Learn how we prioritize safety in construction by following strict structural guidelines and using high-quality materials to ensure buildings are secure and reliable.'),

                    ],


                ],
                'title_field' => '{{{ vernex_faq_section_genaral_question }}}',
            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_area',
            [
                'label'     => esc_html__('Right Side Area', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_area_banner_image',
            [
                'label' => esc_html__('Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => ['style_three', 'style_four'],
                ],
            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_area_shortcode',
            [
                'label'       => esc_html__('Shortcode', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html(''),
                'placeholder' => esc_html__('Type your shortcode here', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_two',
                ],
            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_subtitle',
            [
                'label' => esc_html__('Subtitle', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Ask the Builder'),
                'label_block' => true,
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_title',
            [
                'label' => esc_html__('Title', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Curious About Vernex?'),
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_short_description',
            [
                'label' => esc_html__('Short Description', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We understand your needs and delivery digitaloi marketing through unique selling oneto homeles proposition Our team of expert.'),
                'placeholder' => esc_html__('Type your text here', 'vernex-core'),
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );



        $this->add_control(
            'vernex_faq_section_genaral_right_side_button_text',
            [
                'label' => esc_html__('Button Text', 'vernex-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Contact Us Now', 'vernex-core'),
                'label_block' => true,
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_one',
                ],

            ]
        );

        $this->add_control(
            'vernex_faq_section_genaral_right_side_button_url',
            [
                'label' => esc_html__('Button URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );


        $this->end_controls_section();


        //style start
        $this->start_controls_section(
            'vernex_faql_section_genaral_style_one_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_one',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_one_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_subtitle_after_color',
            [
                'label'     => esc_html__('After Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_one_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_short_description',
            [
                'label'     => esc_html__('Short Description', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_one_general_short_description_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_short_description_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_button',
            [
                'label'     => esc_html__('Button', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_one_general_button_typ',
                'selector' => '{{WRAPPER}} .primary-btn2 span',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_button_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_button_bg_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span svg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_button_icon_color_after',
            [
                'label'     => esc_html__('Icon Color After', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_button_bg_border_color',
            [
                'label'     => esc_html__('Border Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2 span' => 'background-image: linear-gradient(0deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_button_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .primary-btn2' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_faq_question',
            [
                'label'     => esc_html__('Question', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_one_general_faq_question_typ',
                'selector' => '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-header .accordion-button',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_faq_question_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-header .accordion-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_faq_answer',
            [
                'label'     => esc_html__('Answer', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_one_general_faq_answer_typ',
                'selector' => '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-body',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_one_general_faq_answer_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-body' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_faql_section_genaral_style_two_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => ['style_two', 'style_four'],
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_two_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title2 h2',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_title_span_color',
            [
                'label'     => esc_html__('Span Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title2 h2 span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_faq_question',
            [
                'label'     => esc_html__('Question', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_two_general_faq_question_typ',
                'selector' => '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-header .accordion-button',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_faq_question_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-header .accordion-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_faq_answer',
            [
                'label'     => esc_html__('Answer', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_two_general_faq_answer_typ',
                'selector' => '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-header .accordion-button',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_two_general_faq_answer_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-wrap .accordion .accordion-item .accordion-body' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_faql_section_genaral_style_three_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'vernex_faql_section_genaral_style_selection' => 'style_three',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_three_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.four span',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.four span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_three_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title.white h2',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.white h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_step',
            [
                'label'     => esc_html__('Step', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_three_general_faq_step_typ',
                'selector' => '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-header .accordion-button .step-no-and-title span',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_step_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-header .accordion-button .step-no-and-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_step_bg_color',
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-header .accordion-button .step-no-and-title span' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_question',
            [
                'label'     => esc_html__('Question', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_three_general_faq_question_typ',
                'selector' => '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-header .accordion-button .step-no-and-title h6',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_question_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-header .accordion-button .step-no-and-title h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_answer',
            [
                'label'     => esc_html__('Answer', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_faql_section_genaral_style_three_general_faq_answer_typ',
                'selector' => '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-body',

            ]
        );

        $this->add_control(
            'vernex_faql_section_genaral_style_three_general_faq_answer_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home5-faq-section .faq-wrap .accordion .accordion-item .accordion-body' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
?>


        <?php if ($settings['vernex_faql_section_genaral_style_selection'] == 'style_one') : ?>
            <div class="home1-faq-section">
                <div class="container">
                    <div class="row gy-5 justify-content-between">
                        <div class="col-lg-<?php if ($settings['vernex_faql_section_genaral_show_right_side_content'] !== 'yes') : ?>12<?php else : ?>7<?php endif; ?> order-lg-1 order-2">
                            <div class="faq-wrap">
                                <div class="accordion" id="accordionExample">
                                    <?php
                                    $accordion_items = $this->get_settings('vernex_faq_section_genaral_faq_list');
                                    if (!empty($accordion_items)) {
                                        $index = 0;
                                    ?>
                                        <div class="accordion" id="accordionGeneral">
                                            <?php foreach ($accordion_items as $item) :
                                                $is_active = ($index === 0) ? 'show' : '';
                                            ?>
                                                <div class="accordion-item wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                                    <h2 class="accordion-header" id="faqheadingOne<?php echo $index; ?>">
                                                        <button class="accordion-button <?php echo ($index === 0) ? '' : 'collapsed'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#faqcollapse<?php echo $index; ?>" aria-expanded="<?php echo ($index === 0) ? 'true' : 'false'; ?>" aria-controls="faqcollapse<?php echo $index; ?>">
                                                            <?php if (!empty($item['vernex_faq_section_genaral_question'])) : ?>
                                                                <?php echo esc_html($item['vernex_faq_section_genaral_question']); ?>
                                                            <?php endif; ?>
                                                        </button>
                                                    </h2>
                                                    <div id="faqcollapse<?php echo $index; ?>" class="accordion-collapse collapse <?php echo $is_active; ?>" aria-labelledby="faqheadingOne<?php echo $index; ?>" data-bs-parent="#accordionGeneral">
                                                        <div class="accordion-body">
                                                            <?php if (!empty($item['vernex_faq_section_genaral_answer'])) : ?>
                                                                <?php echo esc_html($item['vernex_faq_section_genaral_answer']); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                                $index++;
                                            endforeach; ?>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <?php if ($settings['vernex_faql_section_genaral_show_right_side_content'] == 'yes') : ?>
                            <div class="col-xl-4 col-lg-5 order-lg-2 order-1 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <div class="title-area">
                                    <div class="section-title">
                                        <?php if (!empty($settings['vernex_faq_section_genaral_right_side_subtitle'])) : ?>
                                            <span><?php echo esc_html($settings['vernex_faq_section_genaral_right_side_subtitle']); ?></span>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['vernex_faq_section_genaral_right_side_title'])) : ?>
                                            <h2><?php echo esc_html($settings['vernex_faq_section_genaral_right_side_title']); ?></h2>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['vernex_faq_section_genaral_right_side_short_description'])) : ?>
                                            <p><?php echo esc_html($settings['vernex_faq_section_genaral_right_side_short_description']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($settings['vernex_faq_section_genaral_right_side_button_text'])) : ?>
                                        <div class="button-area">
                                            <a href="<?php echo esc_url($settings['vernex_faq_section_genaral_right_side_button_url']['url']); ?>" class="primary-btn2">
                                                <span>
                                                    <?php echo esc_html($settings['vernex_faq_section_genaral_right_side_button_text']); ?>
                                                    <svg viewBox="0 0 13 20">
                                                        <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                    </svg>
                                                </span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_faql_section_genaral_style_selection'] == 'style_two') : ?>
            <div class="home4-faq-section">
                <div class="container">
                    <div class="row gy-5 align-items-center">
                        <div class="col-lg-<?php if ($settings['vernex_faql_section_genaral_show_right_side_content'] !== 'yes') : ?>12<?php else : ?>5<?php endif; ?> wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <?php if (!empty($settings['vernex_faql_section_genaral_header_title'])) : ?>
                                <div class="section-title2 mb-60">
                                    <h2><?php echo wp_kses($settings['vernex_faql_section_genaral_header_title'], wp_kses_allowed_html('post')); ?> <span></span></h2>
                                </div>
                            <?php endif; ?>
                            <div class="faq-wrap style-2">
                                <div class="accordion" id="accordionExample">
                                    <?php
                                    $accordion_items = $this->get_settings('vernex_faq_section_genaral_faq_list');
                                    if (!empty($accordion_items)) {
                                        $index = 0;
                                    ?>
                                        <div class="accordion" id="accordionGeneral">
                                            <?php foreach ($accordion_items as $item) :
                                                $is_active = ($index === 0) ? 'show' : '';
                                            ?>
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="faqheadingOne<?php echo $index; ?>">
                                                        <button class="accordion-button <?php echo ($index === 0) ? '' : 'collapsed'; ?>"
                                                            type="button"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#faqcollapse<?php echo $index; ?>"
                                                            aria-expanded="<?php echo ($index === 0) ? 'true' : 'false'; ?>"
                                                            aria-controls="faqcollapse<?php echo $index; ?>">
                                                            <?php if (!empty($item['vernex_faq_section_genaral_question'])) : ?>
                                                                <?php echo esc_html($item['vernex_faq_section_genaral_question']); ?>
                                                            <?php endif; ?>
                                                        </button>
                                                    </h2>
                                                    <div id="faqcollapse<?php echo $index; ?>"
                                                        class="accordion-collapse collapse <?php echo $is_active; ?>"
                                                        aria-labelledby="faqheadingOne<?php echo $index; ?>"
                                                        data-bs-parent="#accordionGeneral">
                                                        <div class="accordion-body">
                                                            <?php if (!empty($item['vernex_faq_section_genaral_answer'])) : ?>
                                                                <?php echo esc_html($item['vernex_faq_section_genaral_answer']); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                                $index++;
                                            endforeach; ?>
                                        </div>
                                    <?php
                                    }
                                    ?>

                                </div>
                            </div>
                        </div>
                        <?php if ($settings['vernex_faql_section_genaral_show_right_side_content'] == 'yes') : ?>
                            <div class="col-lg-7 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                <?php if (!empty($settings['vernex_faq_section_genaral_right_side_area_shortcode'])) : ?>
                                    <div class="contact-form-wrap">
                                        <?php echo do_shortcode($settings['vernex_faq_section_genaral_right_side_area_shortcode'])  ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if ($settings['vernex_faql_section_genaral_style_selection'] == 'style_three') : ?>
            <div class="home5-faq-section">
                <div class="container">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-lg-<?php if ($settings['vernex_faql_section_genaral_show_right_side_content'] !== 'yes') : ?>12<?php else : ?>6<?php endif; ?>">
                            <div class="faq-content-area">
                                <div class="section-title four white mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <?php if (!empty($settings['vernex_faql_section_genaral_header_subtitle'])) : ?>
                                        <span><?php echo esc_html($settings['vernex_faql_section_genaral_header_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['vernex_faql_section_genaral_header_title'])) : ?>
                                        <h2><?php echo wp_kses($settings['vernex_faql_section_genaral_header_title'], wp_kses_allowed_html('post')); ?></h2>
                                    <?php endif; ?>
                                </div>
                                <div class="faq-wrap">
                                    <div class="accordion" id="accordionGeneral">
                                        <?php
                                        $accordion_items = $this->get_settings('vernex_faq_section_genaral_faq_list');
                                        if (!empty($accordion_items)) {
                                            $index = 0;
                                        ?>
                                            <?php foreach ($accordion_items as $item) :
                                                $is_active = ($index === 0) ? 'show' : '';
                                                $is_expanded = ($index === 0) ? 'true' : 'false';
                                                $collapsed_class = ($index === 0) ? '' : 'collapsed';
                                            ?>
                                                <div class="accordion-item wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                                    <div class="accordion-header" id="faqheadingOne<?php echo $index; ?>">
                                                        <div class="accordion-button <?php echo $collapsed_class; ?>" role="button" data-bs-toggle="collapse" data-bs-target="#faqcollapse<?php echo $index; ?>" aria-expanded="<?php echo $is_expanded; ?>" aria-controls="faqcollapse<?php echo $index; ?>">
                                                            <div class="step-no-and-title">
                                                                <span><?php echo 'Step ' . str_pad($index + 1, 2, '0', STR_PAD_LEFT) . '.'; ?></span>
                                                                <h6>
                                                                    <?php if (!empty($item['vernex_faq_section_genaral_question'])) : ?>
                                                                        <?php echo esc_html($item['vernex_faq_section_genaral_question']); ?>
                                                                    <?php endif; ?>
                                                                </h6>
                                                            </div>
                                                            <svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M7.89753 13.1434C7.89753 10.5799 10.1789 8.24351 12.6862 8.24351L13.7139 8.24351L13.7139 6.14057L12.6862 6.14057C10.8632 6.14057 9.15329 6.95861 7.89753 8.24246L7.89754 -2.63656e-07L5.84229 -3.56821e-07L5.84229 8.24246C4.58654 6.95861 2.87658 6.14057 1.05358 6.14057L0.0259626 6.14057L0.0259625 8.24351L1.05358 8.24351C3.55995 8.24351 5.84229 10.5799 5.84229 13.1434L5.84229 14.1948L7.89753 14.1948L7.89753 13.1434Z" />
                                                            </svg>
                                                        </div>
                                                    </div>
                                                    <div id="faqcollapse<?php echo $index; ?>"
                                                        class="accordion-collapse collapse <?php echo $is_active; ?>"
                                                        aria-labelledby="faqheadingOne<?php echo $index; ?>"
                                                        data-bs-parent="#accordionGeneral">
                                                        <div class="accordion-body">
                                                            <?php if (!empty($item['vernex_faq_section_genaral_answer'])) : ?>
                                                                <?php echo esc_html($item['vernex_faq_section_genaral_answer']); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                                $index++;
                                            endforeach; ?>
                                        <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if ($settings['vernex_faql_section_genaral_show_right_side_content'] == 'yes') : ?>
                            <?php if (!empty($settings['vernex_faq_section_genaral_right_side_area_banner_image']['url'])) : ?>
                                <div class="col-xl-5 col-lg-6 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <div class="faq-img">
                                        <img src="<?php echo esc_url($settings['vernex_faq_section_genaral_right_side_area_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_faql_section_genaral_style_selection'] == 'style_four') : ?>
            <div class="faq-page pt-120 mb-120">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-xl-5 col-lg-6 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="section-title2 mb-60">
                                <h2><?php echo wp_kses($settings['vernex_faql_section_genaral_header_title'], wp_kses_allowed_html('post')); ?> <span></span></h2>

                            </div>
                            <div class="faq-wrap style-2">
                                <?php
                                $accordion_items = $this->get_settings('vernex_faq_section_genaral_faq_list');
                                if (!empty($accordion_items)) {
                                    $index = 0; // Initialize index for unique IDs
                                ?>
                                    <div class="accordion" id="accordionExample">
                                        <?php foreach ($accordion_items as $item) :
                                            $is_active = ($index === 0) ? 'show' : '';
                                            $collapsed = ($index === 0) ? '' : 'collapsed';
                                        ?>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header" id="heading-<?php echo $index; ?>">
                                                    <button class="accordion-button <?php echo $collapsed; ?>"
                                                        type="button"
                                                        data-bs-toggle="collapse"
                                                        data-bs-target="#collapse-<?php echo $index; ?>"
                                                        aria-expanded="<?php echo ($index === 0) ? 'true' : 'false'; ?>"
                                                        aria-controls="collapse-<?php echo $index; ?>">
                                                        <?php if (!empty($item['vernex_faq_section_genaral_question'])) : ?>
                                                            <?php echo esc_html($item['vernex_faq_section_genaral_question']); ?>
                                                        <?php endif; ?>
                                                    </button>
                                                </h2>
                                                <div id="collapse-<?php echo $index; ?>"
                                                    class="accordion-collapse collapse <?php echo $is_active; ?>"
                                                    aria-labelledby="heading-<?php echo $index; ?>"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="accordion-body">
                                                        <?php if (!empty($item['vernex_faq_section_genaral_answer'])) : ?>
                                                            <?php echo esc_html($item['vernex_faq_section_genaral_answer']); ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php
                                            $index++; // Increment index for next item
                                        endforeach; ?>
                                    </div>
                                <?php
                                }
                                ?>
                            </div>

                        </div>
                        <div class="col-lg-6 d-lg-block d-none wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <?php if (!empty($settings['vernex_faq_section_genaral_right_side_area_banner_image']['url'])) : ?>
                                <div class="faq-img magnetic-item">
                                    <img src="<?php echo esc_url($settings['vernex_faq_section_genaral_right_side_area_banner_image']['url']); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex-core'); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Faq_Widget());
