<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Counter_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_counter';
    }

    public function get_title()
    {
        return esc_html__('EG Counter', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_counter_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_count_section_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_counter_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Who We Are', 'vernex-core'),
                'placeholder' => esc_html__('Write your subtitle here', 'vernex-core'),
                'label_block' => true,
                'condition'   => [
                    'vernex_count_section_style_selection' => [ 'style_two', 'style_three' ],
                ]
            ]
        );

        $this->add_control(
            'vernex_counter_section_genaral_title',
            [
                'label'         => esc_html__('Title', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => wp_kses('Discover More', wp_kses_allowed_html('post')),
                'placeholder'   => esc_html__('write your title here', 'vernex-core'),
                'label_block'   => true,
                'condition'     => [
                    'vernex_count_section_style_selection'  => [ 'style_two' ],
                ]
            ]
        );

        $this->add_control(
            'vernex_counter_section_genaral_text',
            [
                'label'         => esc_html__('Paragraph', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => wp_kses('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.', wp_kses_allowed_html('post')),
                'placeholder'   => esc_html__('write your text here', 'vernex-core'),
                'label_block'   => true,
                'condition'     => [
                    'vernex_count_section_style_selection'  => [ 'style_two' ],
                ]
            ]
        );

        $this->add_control(
            'vernex_counter_section_genaral_btn_text',
            [
                'label'         => esc_html__('Section Button Text', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => esc_html__( 'Learn more', 'vernex-core' ),
                'placeholder'   => esc_html__('write your text here', 'vernex-core'),
                'label_block'   => true,
                'condition'     => [
                    'vernex_count_section_style_selection'  => [ 'style_two' ],
                ]
            ]
        );

        $this->add_control(
            'vernex_counter_section_genaral_btn_link',
            [
                'label'         => esc_html__('Section Button Link', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::URL,
                'default'       => ['#'],
                'condition'     => [
                    'vernex_count_section_style_selection'  => [ 'style_two' ],
                ]
            ]
        );

        $counter_content = new \Elementor\Repeater();

        $counter_content->add_control(
            'vernex_count_item_number',
            [
                'label'       => esc_html__('Counter Number', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => wp_kses('Discover More', wp_kses_allowed_html('post')),
                'placeholder' => esc_html__('write your number here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $counter_content->add_control(
            'vernex_count_item_icon',
            [
                'label'       => esc_html__( 'Count icon', 'vernex-core' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $counter_content->add_control(
            'vernex_count_item_text',
            [
                'label'       => esc_html__('Counter Text', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Green spaces', 'vernex-core'),
                'label-block' => true 
            ]
        );

        $this->add_control(
            'vernex_count_repeater_item',
            [
                'label'       => esc_html__( 'Counter List', 'vernex-core' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $counter_content->get_controls(),
                'default'     => [
                    [
                        'vernex_count_item_number'   => esc_html__( '45', 'vernex-core' ),
                        'vernex_count_item_text'    => esc_html__( 'Green Spaces', 'vernex-core' )
                    ],
                    [
                        'vernex_count_item_number'   => esc_html__( '15', 'vernex-core' ),
                        'vernex_count_item_text'    => esc_html__( 'Skilled professionals', 'vernex-core' )
                    ]
                ],
                'title_field'   =>'{{{ vernex_count_item_text }}}'
            ]
        );

        $this->end_controls_section();

        // style start
        $this->start_controls_section(
            'vernex_count_style_one_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_count_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_count_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title.three span',

            ]
        );

        $this->add_control(
            'vernex_count_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.three span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_count_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_count_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_count_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_count_style_general_ptext',
            [
                'label'     => esc_html__('Paragraph', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_count_general_ptext_typ',
                'selector' => '{{WRAPPER}} .section-title p',

            ]
        );

        $this->add_control(
            'vernex_count_general_ptext_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_count_section_general_background',
            [
                'label'     => esc_html__('Section Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
    
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'name'      => 'vernex_count_section_general_bg_color',
                'selector' => '{{WRAPPER}} .home3-award-section',
            ]
        );

        $this->add_control(
            'vernex_count_style_general_count_items',
            [
                'label'     => esc_html__('Counter Number', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_count_style_general_count_items_title_typ',
                'selector' => '{{WRAPPER}} .home3-counter-section .single-counter .content .number h2',

            ]
        );

        $this->add_control(
            'vernex_count_style_general_count_items_title_color',
            [
                'label'     => esc_html__('Title Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-counter-section .single-counter .content .number h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_count_style_general_count_items_icon',
            [
                'label'     => esc_html__('Counter Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_count_style_general_count_items_icon_typ',
                'selector' => '{{WRAPPER}} .home3-counter-section .single-counter .content .number span',

            ]
        );

        $this->add_control(
            'vernex_count_style_general_count_items_icon_color',
            [
                'label'     => esc_html__('Number Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-counter-section .single-counter .content .number span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_count_style_general_count_items_text',
            [
                'label'     => esc_html__('Counter Item Text', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_count_style_general_count_items_text_typ',
                'selector' => '{{WRAPPER}} .home3-counter-section .single-counter .content p',

            ]
        );

        $this->add_control(
            'vernex_count_style_general_count_items_text_color',
            [
                'label'     => esc_html__('Number Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-counter-section .single-counter .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $counter_content = $settings['vernex_count_repeater_item'];
?>
    <?php if( $settings['vernex_count_section_style_selection'] == 'style_one' ) : ?>
        <div class="home2-counter-section">
        <div class="container">
            <div class="row gy-4">
                <?php foreach( $counter_content as $count) : ?>
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <div class="single-countdown">
                        <div class="number">
                            <?php if( !empty( $count[ 'vernex_count_item_number' ] ) ): ?>
                            <h2 class="counter"><?php echo esc_html( $count['vernex_count_item_number'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( !empty( $count[ 'vernex_count_item_icon' ] ) ): ?>
                            <span><?php echo esc_html( $count['vernex_count_item_icon'] ); ?></span>
                            <?php endif; ?>
                        </div>
                        <?php if( !empty( $count[ 'vernex_count_item_text' ] ) ): ?>
                        <span><?php echo esc_html( $count['vernex_count_item_text']); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if( $settings['vernex_count_section_style_selection'] == 'style_two' ) : ?>
        <div class="home3-counter-section mb-120">
        <div class="container">
            <div class="row g-4 align-items-center justify-content-between mb-80 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                <div class="col-xxl-6 col-lg-7">
                    <div class="section-title three">
                        <?php if( !empty( $settings['vernex_counter_section_genaral_subtitle'] ) ): ?>
                        <span><?php echo esc_html( $settings['vernex_counter_section_genaral_subtitle'] ); ?></span>
                        <?php endif; ?>
                        <?php if( !empty( $settings['vernex_counter_section_genaral_title'] ) ) : ?>
                        <h2><?php echo esc_html( $settings['vernex_counter_section_genaral_title'] ); ?></h2>
                        <?php endif; ?>
                        <?php if( !empty( $settings['vernex_counter_section_genaral_text'] ) ): ?>
                        <p><?php echo esc_html( $settings['vernex_counter_section_genaral_text'] ); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if( !empty( $settings['vernex_counter_section_genaral_btn_text'] ) ): ?>
                <div class="col-lg-2 d-flex justify-content-lg-end">
                    <a href="<?php echo esc_url( $settings['vernex_counter_section_genaral_btn_link']['url'] ); ?>" class="primary-btn">
                        <?php echo esc_html( $settings['vernex_counter_section_genaral_btn_text'] ); ?> 
                        <svg viewBox="0 0 13 20">
                            <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                        </svg>
                    </a>
                </div>
                <?php endif; ?>
            </div>
            <div class="row g-4 justify-content-center">
                <?php foreach( $counter_content as $count ) : ?>
                <div class="col-lg-3 col-sm-6">
                    <div class="single-counter">
                        <div class="content bounce_up">
                            <div class="number">
                            <?php if( !empty( $count[ 'vernex_count_item_number' ] ) ): ?>
                            <h2 class="counter"><?php echo esc_html( $count['vernex_count_item_number'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( !empty( $count[ 'vernex_count_item_icon' ] ) ): ?>
                            <span><?php echo esc_html( $count['vernex_count_item_icon'] ); ?></span>
                            <?php endif; ?>
                            </div>
                            <?php if( !empty( $count[ 'vernex_count_item_text' ] ) ): ?>
                            <p><?php echo esc_html( $count['vernex_count_item_text']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Counter_Widget());
