<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Banner_Video_Area_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_banner_video_area';
    }

    public function get_title()
    {
        return esc_html__('EG Banner Video Area', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_banner_video_area_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_banner_video_area_section_genaral_video_cover_image',
            [
                'label' => esc_html__('Video Banner Image', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_hero_banner_three_section_genaral_button_url',
            [
                'label' => esc_html__('Video  URL', 'vernex-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'vernex-core'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=YKtMErhDpm0',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //style start
        $this->start_controls_section(
            'vernex_banner_video_area_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_banner_video_area_style_general_icon',
            [
                'label'     => esc_html__('Video Icon', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_banner_video_area_style_general_icon_typ',
                'selector' => '{{WRAPPER}} .home3-banner-video-area .play-btn .icon .video-circle',

            ]
        );

        $this->add_control(
            'vernex_banner_video_area_style_general_icon_color',
            [
                'label'     => esc_html__('Icon Color One', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner-video-area .play-btn .icon .video-circle' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_banner_video_area_style_general_icon_two_color',
            [
                'label'     => esc_html__('Icon Color Two', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home3-banner-video-area .play-btn .icon .play-icon' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
?>

        <div class="home3-banner-video-area">
            <div class="video-wrapper">
                <?php if (!empty($settings['vernex_banner_video_area_section_genaral_video_cover_image']['url'])) : ?>
                    <img src="<?php echo esc_url($settings['vernex_banner_video_area_section_genaral_video_cover_image']['url']); ?>" alt="<?php echo esc_attr__('video-banner', 'vernex-core'); ?>">
                    <a data-fancybox="video-player" href="<?php echo esc_url($settings['vernex_hero_banner_three_section_genaral_button_url']['url']); ?>" class="play-btn">
                        <div class="icon">
                            <svg class="video-circle" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="70px" viewBox="0 0 206 206" style="enable-background:new 0 0 206 206;" xml:space="preserve">
                                <circle class="circle" stroke-miterlimit="10" cx="103" cy="103" r="100"></circle>
                                <path class="circle-half top-half" stroke-width="4" stroke-miterlimit="10" d="M16.4,53C44,5.2,105.2-11.2,153,16.4s64.2,88.8,36.6,136.6"></path>
                                <path class="circle-half bottom-half" stroke-width="4" stroke-miterlimit="10" d="M189.6,153C162,200.8,100.8,217.2,53,189.6S-11.2,100.8,16.4,53"></path>
                            </svg>
                            <svg class="play-icon" width="22" height="26" viewBox="0 0 22 26" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.0414 12.6872C21.0414 11.9857 20.68 11.3397 20.0741 10.9581L3.71746 0.667707C3.05587 0.252161 2.24905 0.221801 1.5565 0.588432C0.866106 0.954858 0.453125 1.63119 0.453125 2.39695V22.9762C0.453125 23.742 0.866072 24.4181 1.55755 24.7847C1.87989 24.9547 2.22564 25.0392 2.57141 25.0392C2.96897 25.0392 3.36391 24.927 3.71724 24.7054L20.0739 14.4166C20.68 14.0348 21.0414 13.3888 21.0414 12.6874V12.6872ZM19.4837 13.5246L3.12701 23.8134C2.80597 24.015 2.41492 24.0287 2.07958 23.8524C1.74423 23.6749 1.5435 23.3475 1.5435 22.976V2.39676C1.5435 2.02528 1.74423 1.69657 2.07958 1.52035C2.2363 1.43855 2.40452 1.39701 2.57165 1.39701C2.76458 1.39701 2.9562 1.45119 3.12725 1.55956L19.4839 11.85C19.7817 12.0376 19.9526 12.3438 19.9526 12.6887C19.9523 13.0323 19.7815 13.337 19.4837 13.5246Z"></path>
                            </svg>
                        </div>
                    </a>
                <?php endif; ?>
            </div>
        </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Banner_Video_Area_Widget());
