<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;  // Exit if accessed directly


class Vernex_Award_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'vernex_award';
    }

    public function get_title()
    {
        return esc_html__('EG Award', 'vernex-core');
    }

    public function get_icon()
    {
        return 'vernex-widget-icon';
    }

    public function get_categories()
    {
        return ['vernex_widgets'];
    }

    protected function register_controls()
    {

        //=====================General=======================//

        $this->start_controls_section(
            'vernex_award_section_genaral',
            [
                'label' => esc_html__('General', 'vernex-core')
            ]
        );

        $this->add_control(
            'vernex_award_section_style_selection',
            [
                'label'   => esc_html__('Select Style', 'vernex-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'style_one' => esc_html__('Style One', 'vernex-core'),
                    'style_two' => esc_html__('Style Two', 'vernex-core'),
                    'style_three' => esc_html__('Style Three', 'vernex-core'),
                    'style_four' => esc_html__('Style Four', 'vernex-core'),
                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'vernex_award_section_genaral_subtitle',
            [
                'label'       => esc_html__('Subtitle', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Your subtitle', 'vernex-core'),
                'placeholder' => esc_html__('Write your subtitle here', 'vernex-core'),
                'label_block' => true,
                'condition'   => [
                    'vernex_award_section_style_selection' => ['style_one', 'style_three', 'style_four'],
                ]
            ]
        );

        $this->add_control(
            'vernex_award_section_genaral_title',
            [
                'label'         => esc_html__('Title', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => wp_kses('Real Estate Agent Of The Year.', wp_kses_allowed_html('post')),
                'placeholder'   => esc_html__('write your title here', 'vernex-core'),
                'label_block'   => true,
            ]
        );

        $this->add_control(
            'vernex_award_section_genaral_text',
            [
                'label'         => esc_html__('Paragraph', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'default'       => wp_kses('Sed nisl eros, condimentum nec risus sit amet, finibus conguese.Fusen fringilla est libero sed tempus urna feugiat eu. Curabitur eu feugiat ligu Suspendisse.', wp_kses_allowed_html('post')),
                'placeholder'   => esc_html__('write your text here', 'vernex-core'),
                'label_block'   => true,
                'condition'     => [
                    'vernex_award_section_style_selection' => ['style_three'],
                ]
            ]
        );

        $this->add_control(
            'vernex_award_section_genaral_image',
            [
                'label'         => esc_html__('Section Image', 'vernex-core'),
                'type'          => \Elementor\Controls_Manager::MEDIA,
                'default'       => [
                    'url'       => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'placeholder'   => esc_html__('write your text here', 'vernex-core'),
                'label_block'   => true,
                'condition'     => [
                    'vernex_award_section_style_selection' => ['style_three'],
                ]
            ]
        );

        $faq_content = new \Elementor\Repeater();

        $faq_content->add_control(
            'vernex_award_item_title',
            [
                'label'       => esc_html__('Award Title', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Customer Choice', 'vernex-core'),
                'placeholder' => esc_html__('write your text here', 'vernex-core'),
                'label_block' => true,
            ]
        );

        $faq_content->add_control(
            'vernex_award_item_date',
            [
                'label'       => esc_html__('Award Date', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $faq_content->add_control(
            'vernex_award_item_image',
            [
                'label'       => esc_html__('Award Image', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::MEDIA,
                'default'     => [
                    'url'     => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'vernex_award_repeater_item',
            [
                'label'       => esc_html__('Award List', 'vernex-core'),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $faq_content->get_controls(),
                'default'     => [
                    [
                        'vernex_award_item_title'   => esc_html__('Customer choice', 'vernex-core'),
                        'vernex_award_item_date'    => esc_html__('20 September 2025', 'vernex-core')
                    ],
                    [
                        'vernex_award_item_title'   => esc_html__('Top Influencer', 'vernex-core'),
                        'vernex_award_item_date'    => esc_html__('15 December 2025', 'vernex-core')
                    ]
                ],
                'title_field'   => '{{{ vernex_award_item_title }}}'
            ]
        );

        $this->end_controls_section();

        // style start
        $this->start_controls_section(
            'vernex_award_style_one_style_general',
            [
                'label' => esc_html__('General ', 'vernex-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'vernex_award_style_general_subtitle',
            [
                'label'     => esc_html__('Subtitle', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_award_style_general_subtitle_typ',
                'selector' => '{{WRAPPER}} .section-title span',

            ]
        );

        $this->add_control(
            'vernex_award_style_general_subtitle_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_award_style_general_title',
            [
                'label'     => esc_html__('Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_award_general_title_typ',
                'selector' => '{{WRAPPER}} .section-title h2',

            ]
        );

        $this->add_control(
            'vernex_award_style_general_title_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_award_style_general_ptext',
            [
                'label'     => esc_html__('Paragraph', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_award_general_ptext_typ',
                'selector' => '{{WRAPPER}} .section-title.white p',

            ]
        );

        $this->add_control(
            'vernex_award_general_ptext_color',
            [
                'label'     => esc_html__('Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title.white p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_award_section_general_background',
            [
                'label'     => esc_html__('Section Background', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'label'     => esc_html__('Background Color', 'vernex-core'),
                'name'      => 'vernex_award_section_general_bg_color',
                'selector' => '{{WRAPPER}} .home3-award-section',
            ]
        );

        $this->add_control(
            'vernex_award_style_general_award_items',
            [
                'label'     => esc_html__('Award Items Title', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_award_style_general_award_items_title_typ',
                'selector' => '{{WRAPPER}} .home2-award-section .award-wrap .single-award .title h5',

            ]
        );

        $this->add_control(
            'vernex_award_style_general_award_items_title_color',
            [
                'label'     => esc_html__('Title Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-award-section .award-wrap .single-award .title h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vernex_award_style_general_award_items_date',
            [
                'label'     => esc_html__('Award Items Date', 'vernex-core'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'vernex-core'),
                'name'     => 'vernex_award_style_general_award_items_date_typ',
                'selector' => '{{WRAPPER}} .home2-award-section .award-wrap .single-award .date',

            ]
        );

        $this->add_control(
            'vernex_award_style_general_award_items_date_color',
            [
                'label'     => esc_html__('Date Color', 'vernex-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home2-award-section .award-wrap .single-award .date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $award_contents = $settings['vernex_award_repeater_item'];
?>
        <?php if ($settings['vernex_award_section_style_selection'] == 'style_one') : ?>
            <div class="home2-award-section">
                <div class="container">
                    <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-6">
                            <div class="section-title two text-center">
                                <?php if (!empty($settings['vernex_award_section_genaral_subtitle'])): ?>
                                    <span><?php echo esc_html($settings['vernex_award_section_genaral_subtitle']) ?></span>
                                <?php endif; ?>
                                <h2><?php echo esc_html($settings['vernex_award_section_genaral_title']); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="award-wrap">
                                <?php foreach ($award_contents as $content) : ?>
                                    <div class="single-award wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <?php if (!empty($content['vernex_award_item_title'])): ?>
                                            <div class="title">
                                                <h5><?php echo $content['vernex_award_item_title']; ?></h5>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($content['vernex_award_item_image']['url'])) : ?>
                                            <div class="award-img">
                                                <img src="<?php echo esc_url($content['vernex_award_item_image']['url']); ?>" alt="<?php echo esc_attr__('award-image','vernex-core');?>">
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($content['vernex_award_item_date'])) : ?>
                                            <span class="date"><?php echo esc_html($content['vernex_award_item_date']); ?></span>
                                        <?php endif; ?>
                                        <div class="dot"></div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_award_section_style_selection'] == 'style_two') : ?>
            <div class="home2-award-section two">
                <div class="container">
                    <div class="row justify-content-center mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-6">
                            <div class="section-title two text-center">
                                <?php if (!empty($settings['vernex_award_section_genaral_subtitle'])): ?>
                                    <span><?php echo esc_html($settings['vernex_award_section_genaral_subtitle']) ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_award_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_award_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="award-wrap2">
                                <?php foreach ($award_contents as $content) : ?>
                                    <div class="single-award wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <?php if (!empty($content['vernex_award_item_title'])): ?>
                                            <div class="title">

                                                <h5><?php echo $content['vernex_award_item_title']; ?></h5>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($content['vernex_award_item_image']['url'])) : ?>
                                            <div class="award-img">
                                                <img src="<?php echo esc_url($content['vernex_award_item_image']['url']); ?>" alt="image">
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($content['vernex_award_item_date'])) : ?>
                                            <span class="date"><?php echo esc_html($content['vernex_award_item_date']); ?></span>
                                        <?php endif; ?>
                                        <div class="dot"></div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_award_section_style_selection'] == 'style_three') : ?>
            <div class="home3-award-section">
                <div class="container">
                    <div class="row justify-content-center mb-80 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-xl-7">
                            <div class="section-title three white text-center">
                                <?php if (!empty($settings['vernex_award_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_award_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_award_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_award_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_award_section_genaral_text'])) : ?>
                                    <p><?php echo esc_html($settings['vernex_award_section_genaral_text']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row align-items-center">
                        <div class="col-lg-4 d-lg-block d-none wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <?php if (!empty($settings['vernex_award_section_genaral_image']['url'])) : ?>
                                <div class="award-img magnetic-item">
                                    <img src="<?php echo esc_html($settings['vernex_award_section_genaral_image']['url']); ?>" alt="<?php echo esc_attr__('image','vernex-core');?>">
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-8">
                            <div class="award-list">
                                <div class="row gy-5">
                                    <?php foreach ($award_contents as $content) : ?>
                                        <div class="col-md-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                            <div class="single-award">
                                                <div class="icon">
                                                    <svg width="21" height="21" viewBox="0 0 21 21" xmlns="http://www.w3.org/2000/svg">
                                                        <g>
                                                            <path d="M10.499 0V21" />
                                                            <path d="M0 10.499H21" />
                                                            <path d="M10.499 0V21" />
                                                            <path d="M0 10.499H21" />
                                                            <path d="M14.2628 0.697266L6.7373 20.302" />
                                                            <path d="M0.697266 6.7373L20.302 14.2628" />
                                                            <path d="M17.6608 2.82031L3.33887 18.1788" />
                                                            <path d="M2.82031 3.33887L18.1788 17.6608" />
                                                            <path d="M20.3013 6.73633L0.6875 14.2538" stroke-width="1.00026" />
                                                            <path d="M6.7373 0.697266L14.2548 20.3111" stroke-width="1.00026" />
                                                        </g>
                                                    </svg>
                                                </div>
                                                <div class="content">
                                                    <?php if (!empty($content['vernex_award_item_title'])) : ?>
                                                        <h4><?php echo $content['vernex_award_item_title']; ?></h4>
                                                    <?php endif; ?>
                                                    <?php if (!empty($content['vernex_award_item_date'])) : ?>
                                                        <span><?php echo esc_html($content['vernex_award_item_date']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($settings['vernex_award_section_style_selection'] == 'style_four') : ?>
            <div class="home5-award-section">
                <div class="container-fluid">
                    <div class="row mb-70 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="col-lg-12 d-flex justify-content-center">
                            <div class="section-title four">
                                <?php if (!empty($settings['vernex_award_section_genaral_subtitle'])) : ?>
                                    <span><?php echo esc_html($settings['vernex_award_section_genaral_subtitle']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['vernex_award_section_genaral_title'])) : ?>
                                    <h2><?php echo esc_html($settings['vernex_award_section_genaral_title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="award-area">
                        <div class="row g-4">
                            <?php foreach ($award_contents as $award) : ?>
                                <div class="col-lg-6 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                                    <div class="single-award">
                                        <?php if (!empty($award['vernex_award_item_image']['url'])) : ?>
                                            <div class="logo">
                                                <img src="<?php echo esc_url($award['vernex_award_item_image']['url']); ?>" alt="<?php echo esc_attr__('logo-image', 'vernex-core'); ?>">
                                            </div>
                                        <?php endif; ?>
                                        <svg width="65" height="6" viewBox="0 0 65 6" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.333333 3C0.333333 4.47276 1.52724 5.66667 3 5.66667C4.47276 5.66667 5.66667 4.47276 5.66667 3C5.66667 1.52724 4.47276 0.333333 3 0.333333C1.52724 0.333333 0.333333 1.52724 0.333333 3ZM3 3.5H65V2.5H3V3.5Z" />
                                        </svg>
                                        <?php if (!empty($award['vernex_award_item_title'])) : ?>
                                            <h6><?php echo esc_html($award['vernex_award_item_title']); ?></h6>
                                        <?php endif; ?>
                                        <svg width="53" height="8" viewBox="0 0 53 8" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M52.3536 4.35355C52.5488 4.15829 52.5488 3.84171 52.3536 3.64645L49.1716 0.464466C48.9763 0.269204 48.6597 0.269204 48.4645 0.464466C48.2692 0.659728 48.2692 0.976311 48.4645 1.17157L51.2929 4L48.4645 6.82843C48.2692 7.02369 48.2692 7.34027 48.4645 7.53553C48.6597 7.7308 48.9763 7.7308 49.1716 7.53553L52.3536 4.35355ZM0 4.5H52V3.5H0V4.5Z" />
                                        </svg>
                                        <?php if (!empty($award['vernex_award_item_date'])) : ?>
                                            <span><?php echo esc_html($award['vernex_award_item_date']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new Vernex_Award_Widget());
