<?php

namespace Egns_Core;


/**
 * All Elementor widget init
 * 
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit(); // exit if access directly
}

if (!class_exists('Egns_Elementor')) {

	class Egns_Elementor
	{

		/*
		* $instance
		* @since 1.0.0
		* */
		private static $instance;

		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct()
		{
			//elementor widget category registered
			add_action('elementor/elements/categories_registered', array($this, '_widget_categories'));

			//elementor widget registered
			add_action('elementor/widgets/register', array($this, '_widget_registered'));


			// Enqueue stylesheets in editor page and frontend
			add_action('elementor/editor/before_enqueue_styles', array($this, 'vernex_enqueue_style'));
			add_action('elementor/frontend/before_enqueue_styles', array($this, 'vernex_enqueue_style'));
		}

		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager)
		{
			$elements_manager->add_category(
				'vernex_widgets',
				[
					'title' => esc_html__('Vernex Widgets', 'vernex-core'),
					'icon'  => 'fa fa-plug',
				]
			);
		}

		// Custom widgets css 
		public function vernex_enqueue_style()
		{
			wp_enqueue_style('wp-blocks-library', includes_url('css/dist/block-library/style.min.css'));
			wp_enqueue_style('vernex-widgets', EGNS_CORE_THEME_CSS . '/el-widgets.css', null, filemtime(get_template_directory() . '/assets/css/el-widgets.css'));
		}


		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered()
		{

			if (!class_exists('Elementor\Widget_Base')) {
				return;
			}

			$elementor_widgets = array(

				//common widgets 
				'heading',
				'button',
				'about',
				'team',
				'blog',
				'scroll-text',
				'logo',
				'faq',
				'banner',
				'title-h2',
				'why-choose-us',
				'process',
				'project',
				'service',
				'brand',
				'service-details',
				//home one
				'hero-banner-one',
				'support',
				//home two
				'hero-banner-two',
				'calculation',
				//home three
				'hero-banner-three',
				'banner-video-area',
				'instagram',
				//home four
				'hero-banner-four',
				//home five
				'hero-banner-five',
				//home six
				'hero-banner-six',
				'project-tab',
				'sketch',
				//AWARD [Home 2 section]
				'award',
				'counter',
				'feature',
				'testimonial',
				'project-single',
				'contact',
				'properties',
				'properties-banner',
				'properties-description',


				//footer
				'footer-logo-and-contact',
				'footer-address-area',
				'footer-menu-one',
				'footer-menu-two',
				'footer-copyright',
				'footer-newsletter',
				'footer-title',
			);

			$elementor_widgets = apply_filters('vernex_widgets', $elementor_widgets);

			if (is_array($elementor_widgets) && !empty($elementor_widgets)) {

				foreach ($elementor_widgets as $widget) {

					if (file_exists(EGNS_CORE_INC . '/elementor/widgets/class-' . $widget . '-elementor-widget.php')) {
						require_once EGNS_CORE_INC . '/elementor/widgets/class-' . $widget . '-elementor-widget.php';
					}
				}
			}
		}
	}
	if (class_exists('Egns_Elementor')) {
		Egns_Elementor::getInstance();
	}
} //end if