<?php

/**
 * Custom Post Type
 * Author EgensLab
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
	exit();  //exit if access directly
}
if (!class_exists('poitic_Custom_Post_Type')) {
	class Poitic_Custom_Post_Type
	{

		//$instance variable
		private static $instance;

		public function __construct()
		{
			//register post type
			add_action('init', array($this, 'register_custom_post_type'));
		}

		/**
		 * get Instance
		 * @since  2.0.0
		 * */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Register Custom Post Type
		 * @since  2.0.0
		 * */
		public function register_custom_post_type()
		{
			$all_post_type = array(

				// Custome post project
				[
					'post_type' => 'project',
					'args'      => array(
						'label'       => esc_html__('Projects', 'vernex-core'),
						'description' => esc_html__('Projects', 'vernex-core'),
						'menu_icon'   => 'dashicons-portfolio',
						'labels'      => array(
							'name'               => esc_html_x('Projects', 'Post Type General Name', 'vernex-core'),
							'singular_name'      => esc_html_x('Projects', 'Post Type Singular Name', 'vernex-core'),
							'menu_name'          => esc_html__('Projects', 'vernex-core'),
							'all_items'          => esc_html__('All Projects', 'vernex-core'),
							'view_item'          => esc_html__('View Project', 'vernex-core'),
							'add_new_item'       => esc_html__('Add New Project', 'vernex-core'),
							'add_new'            => esc_html__('Add New Project', 'vernex-core'),
							'edit_item'          => esc_html__('Edit Project', 'vernex-core'),
							'update_item'        => esc_html__('Update Project', 'vernex-core'),
							'search_items'       => esc_html__('Search Project', 'vernex-core'),
							'not_found'          => esc_html__('Not Found', 'vernex-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'vernex-core'),
						),
						'supports'            => array('title', 'editor', 'excerpt', 'thumbnail'),
						'hierarchical'        => true,
						'public'              => true,
						'has_archive'         => true,
						"publicly_queryable"  => true,
						'show_ui'             => true,
						"rewrite"             => array('slug' => 'project', 'with_front' => true),
						'exclude_from_search' => false,
						'can_export'          => true,
						'capability_type'     => 'post',
						'query_var'           => true,
						"show_in_rest"        => true,
					)
				],

				// Custom Post Properties
				[
					'post_type' => 'properties',
					'args'      => array(
						'label'       => esc_html__('Properties', 'vernex-core'),
						'description' => esc_html__('Properties', 'vernex-core'),
						'menu_icon'   => 'dashicons-portfolio',
						'labels'      => array(
							'name'               => esc_html_x('Properties', 'Post Type General Name', 'vernex-core'),
							'singular_name'      => esc_html_x('Properties', 'Post Type Singular Name', 'vernex-core'),
							'menu_name'          => esc_html__('Properties', 'vernex-core'),
							'all_items'          => esc_html__('All Properties', 'vernex-core'),
							'view_item'          => esc_html__('View Properties', 'vernex-core'),
							'add_new_item'       => esc_html__('Add New Properties', 'vernex-core'),
							'add_new'            => esc_html__('Add New Properties', 'vernex-core'),
							'edit_item'          => esc_html__('Edit Properties', 'vernex-core'),
							'update_item'        => esc_html__('Update Properties', 'vernex-core'),
							'search_items'       => esc_html__('Search Properties', 'vernex-core'),
							'not_found'          => esc_html__('Not Found', 'vernex-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'vernex-core'),
						),
						'supports'            => array('title', 'editor', 'excerpt', 'thumbnail'),
						'hierarchical'        => true,
						'public'              => true,
						'has_archive'         => true,
						"publicly_queryable"  => true,
						'show_ui'             => true,
						"rewrite"             => array('slug' => 'properties', 'with_front' => true),
						'exclude_from_search' => false,
						'can_export'          => true,
						'capability_type'     => 'post',
						'query_var'           => true,
						"show_in_rest"        => true,
					)
				],


				// Custome post Career 
				[
					'post_type' => 'footer_blocks',
					'args'      => array(
						'label'              => esc_html__('Footer Blocks', 'vernex-core'),
						'description'        => esc_html__('Footer Blocks', 'vernex-core'),
						'menu_icon'          => 'dashicons-admin-post',
						'labels'             => array(
							'name'               => esc_html_x('Footer Blocks', 'Post Type General Name', 'vernex-core'),
							'singular_name'      => esc_html_x('Footer Blocks', 'Post Type Singular Name', 'vernex-core'),
							'menu_name'          => esc_html__('Footer Blocks', 'vernex-core'),
							'all_items'          => esc_html__('All Footer Blocks', 'vernex-core'),
							'view_item'          => esc_html__('View Footer Blocks', 'vernex-core'),
							'add_new_item'       => esc_html__('Add New Footer Blocks', 'vernex-core'),
							'add_new'            => esc_html__('Add New Footer Blocks', 'vernex-core'),
							'edit_item'          => esc_html__('Edit Footer Blocks', 'vernex-core'),
							'update_item'        => esc_html__('Update Footer Blocks', 'vernex-core'),
							'search_items'       => esc_html__('Search Footer Blocks', 'vernex-core'),
							'not_found'          => esc_html__('Not Found', 'vernex-core'),
							'not_found_in_trash' => esc_html__('Not found in Trash', 'vernex-core'),
						),
						'supports'            => array('title', 'editor', 'excerpt', 'thumbnail'),
						'hierarchical'        => true,
						'public'              => true,
						'has_archive' 		  => true,
						"publicly_queryable"  => true,
						'show_ui'             => true,
						"rewrite" 			  => array('slug' => 'footer-blocks', 'with_front' => true),
						'exclude_from_search' => false,
						'can_export'          => true,
						'capability_type'     => 'post',
						'query_var'           => true,
						"show_in_rest"		  => true,
					)
				],
			);

			if (!empty($all_post_type) && is_array($all_post_type)) {
				foreach ($all_post_type as $post_type) {
					call_user_func_array('register_post_type', $post_type);
				}
			}

			/**
			 * Custom Taxonomy Register
			 */
			$all_custom_taxonmy = array(

				// Taxonomy for project Category
				array(
					'taxonomy'    => 'project-category',
					'object_type' => 'project',
					'args'        => array(
						"labels"  => array(
							"name"          => esc_html__("Categories", 'vernex-core'),
							"singular_name" => esc_html__("Categories", 'vernex-core'),
							"menu_name"     => esc_html__("Categories", 'vernex-core'),
							"all_items"     => esc_html__("All project Categories", 'vernex-core'),
							"add_new_item"  => esc_html__("Add New Category", 'vernex-core')
						),
						"public"             => true,
						"hierarchical"       => true,
						'has_archive'        => true,
						"show_ui"            => true,
						"show_in_menu"       => true,
						"show_in_nav_menus"  => true,
						"rewrite"            => array('slug' => 'project-category', 'with_front' => true),
						"query_var"          => true,
						"show_admin_column"  => true,
						"show_in_rest"       => true,
						"show_in_quick_edit" => true,
					)
				),

				// Taxonomy for Properties post
				array(
					'taxonomy'    => 'properties-status',
					'object_type' => 'properties',
					'args'        => array(
						"labels"  => array(
							"name"          => esc_html__("Status", 'vernex-core'),
							"singular_name" => esc_html__("Status", 'vernex-core'),
							"menu_name"     => esc_html__("Status", 'vernex-core'),
							"all_items"     => esc_html__("All project Status", 'vernex-core'),
							"add_new_item"  => esc_html__("Add New Status", 'vernex-core')
						),
						"public"             => true,
						"hierarchical"       => true,
						'has_archive'        => true,
						"show_ui"            => true,
						"show_in_menu"       => true,
						"show_in_nav_menus"  => true,
						"rewrite"            => array('slug' => 'properties-Status', 'with_front' => true),
						"query_var"          => true,
						"show_admin_column"  => true,
						"show_in_rest"       => true,
						"show_in_quick_edit" => true,
					)
				),

				// Taxonomy for Properties post
				array(
					'taxonomy'    => 'properties-type',
					'object_type' => 'properties',
					'args'        => array(
						"labels"  => array(
							"name"          => esc_html__("Type", 'vernex-core'),
							"singular_name" => esc_html__("Type", 'vernex-core'),
							"menu_name"     => esc_html__("Type", 'vernex-core'),
							"all_items"     => esc_html__("All project Type", 'vernex-core'),
							"add_new_item"  => esc_html__("Add New Type", 'vernex-core')
						),
						"public"             => true,
						"hierarchical"       => true,
						'has_archive'        => true,
						"show_ui"            => true,
						"show_in_menu"       => true,
						"show_in_nav_menus"  => true,
						"rewrite"            => array('slug' => 'properties-type', 'with_front' => true),
						"query_var"          => true,
						"show_admin_column"  => true,
						"show_in_rest"       => true,
						"show_in_quick_edit" => true,
					)
				),

				// Taxonomy for Properties post
				array(
					'taxonomy'    => 'properties-location',
					'object_type' => 'properties',
					'args'        => array(
						"labels"  => array(
							"name"          => esc_html__("Location", 'vernex-core'),
							"singular_name" => esc_html__("Location", 'vernex-core'),
							"menu_name"     => esc_html__("Location", 'vernex-core'),
							"all_items"     => esc_html__("All project Location", 'vernex-core'),
							"add_new_item"  => esc_html__("Add New Location", 'vernex-core')
						),
						"public"             => true,
						"hierarchical"       => true,
						'has_archive'        => true,
						"show_ui"            => true,
						"show_in_menu"       => true,
						"show_in_nav_menus"  => true,
						"rewrite"            => array('slug' => 'properties-location', 'with_front' => true),
						"query_var"          => true,
						"show_admin_column"  => true,
						"show_in_rest"       => true,
						"show_in_quick_edit" => true,
					)
				),

			);
			if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
				foreach ($all_custom_taxonmy as $taxonomy) {
					call_user_func_array('register_taxonomy', $taxonomy);
				}
			}

			flush_rewrite_rules();
		}
	} //end class

	if (class_exists('poitic_Custom_Post_Type')) {
		Poitic_Custom_Post_Type::getInstance();
	}
}
