document.addEventListener('DOMContentLoaded', function () {
    // Mobile menu elements
    const mobileToggle = document.querySelector('.mobile-menu-toggle');
    const mobileNav = document.querySelector('.mobile-nav');
    const mobileOverlay = document.querySelector('.mobile-nav-overlay');
    const mobileCloseBtn = document.querySelector('.mobile-close-btn');


    // Mobile submenu elements
    const mobileNavHeaders = document.querySelectorAll('.mobile-nav-header-item');
    const mobileBackBtns = document.querySelectorAll('.mobile-back-btn');

// nav js start mobile
  // Mobile menu toggle
    function openMobileMenu() {
        mobileToggle.classList.add('active');
        mobileNav.classList.add('active');
        mobileOverlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    }

    function closeMobileMenu() {
        mobileToggle.classList.remove('active');
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = '';

        // Close any open submenus
        document.querySelectorAll('.mobile-submenu').forEach(submenu => {
            submenu.classList.remove('active');
        });
    }

    mobileToggle.addEventListener('click', openMobileMenu);
    mobileCloseBtn.addEventListener('click', closeMobileMenu);
    mobileOverlay.addEventListener('click', closeMobileMenu);

    // Mobile submenu navigation (slide from right to left)
    mobileNavHeaders.forEach(header => {
        header.addEventListener('click', function () {
            const navItem = this.parentElement;
            const submenu = navItem.querySelector('.mobile-submenu');

            if (submenu) {
                submenu.classList.add('active');
            }
        });
    });

    // Mobile back button functionality
    mobileBackBtns.forEach(backBtn => {
        backBtn.addEventListener('click', function () {
            const submenu = this.closest('.mobile-submenu');
            submenu.classList.remove('active');
        });
    });

    // Close mobile menu when clicking on links
    const mobileLinks = document.querySelectorAll('.mobile-nav a:not(.mobile-back-btn)');
    mobileLinks.forEach(link => {
        link.addEventListener('click', function () {
            closeMobileMenu();
        });
    });


})

$(document).ready(function () {

    // Accordion functionality
    $('.sector-page-accordion-header').click(function () {
        const $currentItem = $(this).parent();
        const $currentContent = $(this).next('.sector-page-accordion-content');
        const $currentIcon = $(this).find('.sector-page-accordion-icon');

        // Check if current item is already active
        const isActive = $currentItem.hasClass('active');

        // Close all other accordion items with smooth animation
        $('.sector-page-accordion-item.active').each(function () {
            if (!$(this).is($currentItem)) {
                $(this).removeClass('active');
                $(this).find('.sector-page-accordion-content').slideUp(400, 'easeInOutQuart');
                $(this).find('.sector-page-accordion-icon').css('transform', 'rotate(0deg)');
            }
        });

        // Toggle current item
        if (isActive) {
            // Close current item
            $currentItem.removeClass('active');
            $currentContent.slideUp(400, 'easeInOutQuart');
            $currentIcon.css('transform', 'rotate(0deg)');
        } else {
            // Open current item with slight delay for smoother transition
            setTimeout(function () {
                $currentItem.addClass('active');
                $currentContent.slideDown(400, 'easeInOutQuart');
                $currentIcon.css('transform', 'rotate(180deg)');
            }, 100);
        }
    });

    // Add custom easing if not available
    if (!$.easing.easeInOutQuart) {
        $.easing.easeInOutQuart = function (x, t, b, c, d) {
            if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b;
            return -c / 2 * ((t -= 2) * t * t * t - 2) + b;
        };
    }
});

$(document).ready(function () {

    // Accordion functionality
    $('.sector-page-accordion-header-second').click(function () {
        const $currentItem = $(this).parent();
        const $currentContent = $(this).next('.sector-page-accordion-content-second');
        const $currentIcon = $(this).find('.sector-page-accordion-icon-second');

        // Check if current item is already active
        const isActive = $currentItem.hasClass('active');

        // Close all other accordion items with smooth animation
        $('.sector-page-accordion-item-second.active').each(function () {
            if (!$(this).is($currentItem)) {
                $(this).removeClass('active');
                $(this).find('.sector-page-accordion-content-second').slideUp(400, 'easeInOutQuart');
                $(this).find('.sector-page-accordion-icon-second').css('transform', 'rotate(0deg)');
            }
        });

        // Toggle current item
        if (isActive) {
            // Close current item
            $currentItem.removeClass('active');
            $currentContent.slideUp(400, 'easeInOutQuart');
            $currentIcon.css('transform', 'rotate(0deg)');
        } else {
            // Open current item with slight delay for smoother transition
            setTimeout(function () {
                $currentItem.addClass('active');
                $currentContent.slideDown(400, 'easeInOutQuart');
                $currentIcon.css('transform', 'rotate(180deg)');
            }, 100);
        }
    });

    // Add custom easing if not available
    if (!$.easing.easeInOutQuart) {
        $.easing.easeInOutQuart = function (x, t, b, c, d) {
            if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b;
            return -c / 2 * ((t -= 2) * t * t * t - 2) + b;
        };
    }
});


// nav bar js start

// nav bar js end

// Category js start
document.addEventListener('DOMContentLoaded', function () {
    const serviceItems = document.querySelectorAll('.service-item');
    const serviceDisplays = document.querySelectorAll('.service-display');

    serviceItems.forEach(item => {
        item.addEventListener('click', function () {
            const serviceType = this.getAttribute('data-service');

            // Remove active class from all items and displays
            serviceItems.forEach(si => si.classList.remove('active'));
            serviceDisplays.forEach(sd => sd.classList.remove('active'));

            // Add active class to clicked item
            this.classList.add('active');

            // Show corresponding service display with slight delay for smooth transition
            setTimeout(() => {
                const targetDisplay = document.querySelector(`.service-display[data-service="${serviceType}"]`);
                if (targetDisplay) {
                    targetDisplay.classList.add('active');
                }
            }, 100);
        });
    });

    // Smooth scroll behavior for view all link
    document.querySelector('.view-all a').addEventListener('click', function (e) {
        e.preventDefault();
        console.log('Navigate to all services page');
    });
});
// Category js end

// circle js start

const counters = document.querySelectorAll('.jandk-circle-number');
let isAnimating = false;

function resetCounters() {
    counters.forEach(counter => {
        counter.innerText = '0';
        if (counter.getAttribute('data-suffix')) {
            counter.innerText = '0';
        }
    });
}

function animateCounters() {
    if (isAnimating) return;

    const section = document.getElementById('jandk-stats');
    const sectionTop = section.getBoundingClientRect().top;
    const sectionBottom = section.getBoundingClientRect().bottom;
    const windowHeight = window.innerHeight;

    // Check if section is in viewport
    if (sectionTop < windowHeight - 100 && sectionBottom > 100) {
        isAnimating = true;

        counters.forEach((counter, index) => {
            const target = +counter.getAttribute('data-target');
            const suffix = counter.getAttribute('data-suffix') || '';
            let current = 0;
            const duration = 2000; // 2 seconds
            const startTime = performance.now();

            // Add delay for staggered animation
            setTimeout(() => {
                const updateCount = (currentTime) => {
                    const elapsed = currentTime - startTime;
                    const progress = Math.min(elapsed / duration, 1);

                    // Easing function for smooth animation
                    const easeOutQuart = 1 - Math.pow(1 - progress, 4);
                    current = Math.floor(target * easeOutQuart);

                    counter.innerText = current + suffix;

                    if (progress < 1) {
                        requestAnimationFrame(updateCount);
                    } else {
                        counter.innerText = target + suffix;
                    }
                };

                requestAnimationFrame(updateCount);
            }, index * 200); // 200ms delay between each counter
        });
    }
    // Reset when section is out of view
    else if (sectionTop > windowHeight || sectionBottom < 0) {
        if (isAnimating) {
            resetCounters();
            isAnimating = false;
        }
    }
}

// Use Intersection Observer for better performance
const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            animateCounters();
        } else {
            // Reset when out of view
            setTimeout(() => {
                if (!entry.isIntersecting) {
                    resetCounters();
                    isAnimating = false;
                }
            }, 500);
        }
    });
}, {
    threshold: 0.3,
    rootMargin: '-50px 0px -50px 0px'
});

observer.observe(document.getElementById('jandk-stats'));

// Fallback scroll listener
window.addEventListener('scroll', animateCounters);

// ciecle js end



// footer js start

// BuildTwin Exact Match Interactive Features
class BuildTwinExactWebsite {
    constructor() {
        this.initializeComponents();
        this.setupInteractions();
        this.handleResponsiveLayout();
        this.addAccessibilityEnhancements();
    }

    initializeComponents() {
        // Cache DOM elements for better performance
        this.elements = {
            scheduleBtn: document.querySelector('.btx-cta-button'),
            locationCards: document.querySelectorAll('.btx-location-card'),
            categoryLinks: document.querySelectorAll('.btx-item-link'),
            getStartedLink: document.querySelector('.btx-start-link'),
            locationsContainer: document.querySelector('.btx-locations-container'),
            categoriesGrid: document.querySelector('.btx-categories-grid')
        };
    }

    setupInteractions() {
        // Schedule call button
        if (this.elements.scheduleBtn) {
            this.elements.scheduleBtn.addEventListener('click', this.handleScheduleCall.bind(this));
        }

        // Location cards interactions
        this.elements.locationCards.forEach(card => {
            card.addEventListener('click', this.handleLocationSelect.bind(this));
            card.addEventListener('mouseenter', this.handleLocationHover.bind(this));
            card.addEventListener('mouseleave', this.handleLocationLeave.bind(this));

            // Make cards focusable
            card.setAttribute('tabindex', '0');
            card.setAttribute('role', 'button');

            // Keyboard support
            card.addEventListener('keydown', (e) => {
                if (e.key === 'Enter' || e.key === ' ') {
                    e.preventDefault();
                    this.handleLocationSelect(e);
                }
            });
        });

        // Category links
        this.elements.categoryLinks.forEach(link => {
            link.addEventListener('click', this.handleCategoryClick.bind(this));
        });

        // Get started link
        if (this.elements.getStartedLink) {
            this.elements.getStartedLink.addEventListener('click', this.handleGetStarted.bind(this));
        }
    }


    handleResponsiveLayout() {
        let resizeTimer;

        window.addEventListener('resize', () => {
            clearTimeout(resizeTimer);
            resizeTimer = setTimeout(() => {
                this.adjustLayoutForViewport();
            }, 250);
        });

        // Initial layout adjustment
        this.adjustLayoutForViewport();
    }

    adjustLayoutForViewport() {
        const viewportWidth = window.innerWidth;

        // Dynamic adjustments based on exact breakpoints
        if (viewportWidth <= 480) {
            this.applyMobileLayout();
        } else if (viewportWidth <= 768) {
            this.applyTabletLayout();
        } else if (viewportWidth <= 1200) {
            this.applyDesktopSmallLayout();
        } else {
            this.applyDesktopLargeLayout();
        }
    }

    applyMobileLayout() {
        if (this.elements.locationsContainer) {
            this.elements.locationsContainer.style.gridTemplateColumns = '1fr 1fr';
        }
        if (this.elements.categoriesGrid) {
            this.elements.categoriesGrid.style.gridTemplateColumns = '1fr';
        }
    }

    applyTabletLayout() {
        if (this.elements.locationsContainer) {
            this.elements.locationsContainer.style.gridTemplateColumns = 'repeat(3, 1fr)';
        }
        if (this.elements.categoriesGrid) {
            this.elements.categoriesGrid.style.gridTemplateColumns = 'repeat(2, 1fr)';
        }
    }

    applyDesktopSmallLayout() {
        if (this.elements.locationsContainer) {
            this.elements.locationsContainer.style.gridTemplateColumns = 'repeat(3, 1fr)';
        }
        if (this.elements.categoriesGrid) {
            this.elements.categoriesGrid.style.gridTemplateColumns = 'repeat(3, 1fr)';
        }
    }

    applyDesktopLargeLayout() {
        if (this.elements.locationsContainer) {
            this.elements.locationsContainer.style.gridTemplateColumns = 'repeat(6, 1fr)';
        }
        if (this.elements.categoriesGrid) {
            this.elements.categoriesGrid.style.gridTemplateColumns = 'repeat(6, 1fr)';
        }
    }

    addAccessibilityEnhancements() {
        // Add ARIA labels to location cards
        this.elements.locationCards.forEach(card => {
            const locationName = card.querySelector('.btx-location-label').textContent;
            card.setAttribute('aria-label', `Select ${locationName} region`);
        });

        // Add skip navigation
        this.addSkipNavigation();

        // Announce dynamic content changes
        this.createAriaLiveRegion();
    }

    addSkipNavigation() {
        const skipLink = document.createElement('a');
        skipLink.href = '#main-content';
        skipLink.textContent = 'Skip to main content';
        skipLink.className = 'btx-skip-nav';

        // Skip link styles
        const skipStyles = `
            position: absolute;
            top: -40px;
            left: 8px;
            background: #1e3a5f;
            color: white;
            padding: 8px 16px;
            text-decoration: none;
            border-radius: 4px;
            z-index: 1000;
            font-size: 14px;
            transition: top 0.3s ease;
        `;

        skipLink.style.cssText = skipStyles;

        skipLink.addEventListener('focus', () => {
            skipLink.style.top = '8px';
        });

        skipLink.addEventListener('blur', () => {
            skipLink.style.top = '-40px';
        });

        document.body.insertBefore(skipLink, document.body.firstChild);

        // Add main content ID
        const mainContent = document.querySelector('.btx-content-area');
        if (mainContent) {
            mainContent.id = 'main-content';
        }
    }

    createAriaLiveRegion() {
        const liveRegion = document.createElement('div');
        liveRegion.setAttribute('aria-live', 'polite');
        liveRegion.setAttribute('aria-atomic', 'true');
        liveRegion.className = 'btx-sr-only';
        liveRegion.style.cssText = `
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        `;

        document.body.appendChild(liveRegion);
        this.ariaLiveRegion = liveRegion;
    }

    showNotification(message, type = 'info') {
        // Update ARIA live region for screen readers
        if (this.ariaLiveRegion) {
            this.ariaLiveRegion.textContent = message;
        }

        // Visual notification (simple console log for demo)
        console.log(`${type.toUpperCase()}: ${message}`);

        // In a real implementation, this would show a toast notification
    }

    trackInteraction(eventName, eventData) {
        // Analytics tracking placeholder
        console.log(`Analytics: ${eventName}`, eventData);

        // Real implementation would send to analytics service
        // Example: gtag('event', eventName, eventData);
        // Example: analytics.track(eventName, eventData);
    }

    // Utility method for smooth scrolling
    smoothScrollTo(targetSelector) {
        const target = document.querySelector(targetSelector);
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    }
}

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', () => {
    new BuildTwinExactWebsite();
});

// Performance monitoring
window.addEventListener('load', () => {
    if ('performance' in window) {
        const perfData = performance.getEntriesByType('navigation')[0];
        if (perfData) {
            console.log('Page load performance:', {
                loadTime: Math.round(perfData.loadEventEnd - perfData.loadEventStart),
                domContentLoaded: Math.round(perfData.domContentLoadedEventEnd - perfData.domContentLoadedEventStart),
                firstPaint: Math.round(perfData.responseEnd - perfData.requestStart)
            });
        }
    }
});

// footer js end

// hero js start
document.addEventListener('DOMContentLoaded', function () {
    const ctaButton = document.querySelector('.hero-bottom-cta-button');

    ctaButton.addEventListener('click', function (e) {
        e.preventDefault();
        this.style.transform = 'translateY(-2px) scale(0.98)';
        setTimeout(() => { this.style.transform = ''; }, 150);
        const contactSection = document.querySelector('#contact');
        if (contactSection) {
            contactSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
    });

    let ticking = false;
    function updateParallax() {
        const scrolled = window.pageYOffset;
        const parallaxElements = document.querySelectorAll('.hero-bottom-shape');
        parallaxElements.forEach((element, index) => {
            const speed = 0.5 + (index * 0.2);
            const yPos = -(scrolled * speed);
            element.style.transform += ` translateY(${yPos}px)`;
        });
        ticking = false;
    }

    function requestTick() {
        if (!ticking) {
            requestAnimationFrame(updateParallax);
            ticking = true;
        }
    }

    window.addEventListener('scroll', requestTick);

    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.animationPlayState = 'running';
            }
        });
    }, observerOptions);

    const animatedElements = document.querySelectorAll('.hero-bottom-content > *');
    animatedElements.forEach(el => observer.observe(el));
});
// hero js end


// logo js start
$(document).ready(function () {
    const $slider = $(".logo-slider");
    const $container = $(".logo-slider-container");

    // Clone logos for infinite loop
    $slider.append($slider.html());

    let sliderWidth = $slider[0].scrollWidth / 2; // original width before duplication
    let currentScroll = 0;
    const speed = 0.5; // adjust scroll speed

    function scrollLogos() {
        currentScroll += speed;
        if (currentScroll >= sliderWidth) {
            currentScroll = 0;
        }
        $slider.css("transform", `translateX(-${currentScroll}px)`);
        requestAnimationFrame(scrollLogos);
    }

    scrollLogos();

    // Pause on hover
    let paused = false;
    $container.on("mouseenter", () => (paused = true));
    $container.on("mouseleave", () => (paused = false));

    function checkPause() {
        if (!paused) scrollLogos();
        else requestAnimationFrame(checkPause);
    }

    checkPause();
});
// logo js end

// modern js start
$(document).ready(function () {
    // Initialize Images Slider Only
    $('.modern-images-slider').slick({
        dots: false,
        arrows: false, // We'll use custom arrows
        infinite: true,
        speed: 600,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 4000,
        pauseOnHover: true,
        cssEase: 'ease-in-out',
        responsive: [
            {
                breakpoint: 1200,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    centerMode: false,
                    centerPadding: '20px'
                }
            },
            {
                breakpoint: 480,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    centerMode: false,
                    centerPadding: '15px'
                }
            }
        ]
    });

    // Custom navigation for image slider only
    $('.modern-slider-prev').click(function () {
        $('.modern-images-slider').slick('slickPrev');
    });

    $('.modern-slider-next').click(function () {
        $('.modern-images-slider').slick('slickNext');
    });
});
// modern js end

// news js start -------------------------------------
$(document).ready(() => {
    // Initialize Slider
    $(".news-log-slider").slick({
        dots: false,
        arrows: false,
        infinite: true,
        speed: 600,
        slidesToShow: 2,
        slidesToScroll: 1,
        autoplay: false,
        cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1)",
        responsive: [
            {
                breakpoint: 992,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    centerMode: false,
                    variableWidth: false,
                },
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    centerMode: false,
                    centerPadding: "0px",
                    variableWidth: false,
                },
            },
        ],
    })

    // Set initial positions for desktop
    function setInitialPositions() {
        if ($(window).width() > 992) {
            $(".news-log-slider .slick-slide.slick-active:nth-child(odd) .news-log-slide-card").css(
                "transform",
                "translateY(60px)",
            )

            $(".news-log-slider .slick-slide.slick-active:nth-child(even) .news-log-slide-card").css(
                "transform",
                "translateY(-60px)",
            )
        }
    }

    // Call initially
    setInitialPositions()

    // Handle window resize
    $(window).on("resize", () => {
        setInitialPositions()
    })

    // Handle slide change for desktop - DURING transition
    $(".news-log-slider").on("beforeChange", (event, slick, currentSlide, nextSlide) => {
        if ($(window).width() > 992) {
            // Reset all slides
            $(".news-log-slide-card").css("transform", "translateY(0)")

            // Calculate which slides will be active after the change
            var nextActiveSlides = []
            nextActiveSlides.push(nextSlide)

            // Determine the second active slide (depends on direction)
            var direction = nextSlide > currentSlide || (currentSlide === slick.slideCount - 1 && nextSlide === 0) ? 1 : -1
            var secondSlide = (nextSlide + direction) % slick.slideCount
            if (secondSlide < 0) secondSlide = slick.slideCount - 1

            nextActiveSlides.push(secondSlide)

            // Apply staggered effect to the upcoming active slides
            nextActiveSlides.forEach((slideIndex, i) => {
                var $slide = $('.news-log-slider .slick-slide[data-slick-index="' + slideIndex + '"]')
                if (i % 2 === 0) {
                    // Even index (first slide)
                    $slide.find(".news-log-slide-card").css("transform", "translateY(60px)")
                } else {
                    // Odd index (second slide)
                    $slide.find(".news-log-slide-card").css("transform", "translateY(-60px)")
                }
            })
        }
    })

    // Custom navigation - simplified for infinite looping
    $(".news-prev").click(() => {
        $(".news-log-slider").slick("slickPrev")
    })

    $(".news-next").click(() => {
        $(".news-log-slider").slick("slickNext")
    })
})

// news js end

// testimoneal js start
document.addEventListener('DOMContentLoaded', function () {
    const testimonials = document.querySelectorAll('.testimonial-item');
    const prevBtn = document.querySelector('.testimonial-prev');
    const nextBtn = document.querySelector('.testimonial-next');
    let currentIndex = 0;
    let isAnimating = false; // Prevents rapid clicks

    function showTestimonial(index) {
        if (isAnimating) return;
        isAnimating = true;

        // Hide all testimonials
        testimonials.forEach(testimonial => {
            testimonial.classList.remove('active');
        });

        // Show current testimonial
        testimonials[index].classList.add('active');

        // Reset animation lock after transition
        setTimeout(() => {
            isAnimating = false;
        }, 500); // Match this with your CSS transition time
    }

    // Loop-enabled navigation
    function goToPrev() {
        currentIndex = (currentIndex - 1 + testimonials.length) % testimonials.length;
        showTestimonial(currentIndex);
    }

    function goToNext() {
        currentIndex = (currentIndex + 1) % testimonials.length;
        showTestimonial(currentIndex);
    }

    // Remove existing listeners to prevent duplicates
    prevBtn.removeEventListener('click', goToPrev);
    nextBtn.removeEventListener('click', goToNext);

    // Add fresh event listeners
    prevBtn.addEventListener('click', goToPrev);
    nextBtn.addEventListener('click', goToNext);

    // Initialize
    showTestimonial(currentIndex);
});
// testimoneal js end




// scroll js start here 

document.addEventListener("DOMContentLoaded", () => {
    const scrollProgress = document.querySelector(".scroll-progress")

    function updateScrollProgress() {
        // Calculate scroll percentage
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop
        const scrollHeight = document.documentElement.scrollHeight - window.innerHeight
        const scrollPercentage = (scrollTop / scrollHeight) * 100

        // Update progress bar height (fills downward from top)
        scrollProgress.style.height = `${Math.min(scrollPercentage, 100)}%`
    }

    // Update on scroll
    window.addEventListener("scroll", updateScrollProgress)

    // Update on resize
    window.addEventListener("resize", updateScrollProgress)

    // Initial update
    updateScrollProgress()
})
// scroll js end gere