document.addEventListener('DOMContentLoaded', function () {
      const ctaButton = document.querySelector('.hero-bottom-cta-button');

      ctaButton.addEventListener('click', function (e) {
        e.preventDefault();
        this.style.transform = 'translateY(-2px) scale(0.98)';
        setTimeout(() => { this.style.transform = ''; }, 150);
        const contactSection = document.querySelector('#contact');
        if (contactSection) {
          contactSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
      });

      let ticking = false;
      function updateParallax() {
        const scrolled = window.pageYOffset;
        const parallaxElements = document.querySelectorAll('.hero-bottom-shape');
        parallaxElements.forEach((element, index) => {
          const speed = 0.5 + (index * 0.2);
          const yPos = -(scrolled * speed);
          element.style.transform += ` translateY(${yPos}px)`;
        });
        ticking = false;
      }

      function requestTick() {
        if (!ticking) {
          requestAnimationFrame(updateParallax);
          ticking = true;
        }
      }

      window.addEventListener('scroll', requestTick);

      const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
      };

      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.style.animationPlayState = 'running';
          }
        });
      }, observerOptions);

      const animatedElements = document.querySelectorAll('.hero-bottom-content > *');
      animatedElements.forEach(el => observer.observe(el));
    });