
    const counters = document.querySelectorAll('.jandk-circle-number');
    let isAnimating = false;

    function resetCounters() {
      counters.forEach(counter => {
        counter.innerText = '0';
        if (counter.getAttribute('data-suffix')) {
          counter.innerText = '0';
        }
      });
    }

    function animateCounters() {
      if (isAnimating) return;
      
      const section = document.getElementById('jandk-stats');
      const sectionTop = section.getBoundingClientRect().top;
      const sectionBottom = section.getBoundingClientRect().bottom;
      const windowHeight = window.innerHeight;

      // Check if section is in viewport
      if (sectionTop < windowHeight - 100 && sectionBottom > 100) {
        isAnimating = true;
        
        counters.forEach((counter, index) => {
          const target = +counter.getAttribute('data-target');
          const suffix = counter.getAttribute('data-suffix') || '';
          let current = 0;
          const duration = 2000; // 2 seconds
          const startTime = performance.now();
          
          // Add delay for staggered animation
          setTimeout(() => {
            const updateCount = (currentTime) => {
              const elapsed = currentTime - startTime;
              const progress = Math.min(elapsed / duration, 1);
              
              // Easing function for smooth animation
              const easeOutQuart = 1 - Math.pow(1 - progress, 4);
              current = Math.floor(target * easeOutQuart);
              
              counter.innerText = current + suffix;
              
              if (progress < 1) {
                requestAnimationFrame(updateCount);
              } else {
                counter.innerText = target + suffix;
              }
            };
            
            requestAnimationFrame(updateCount);
          }, index * 200); // 200ms delay between each counter
        });
      } 
      // Reset when section is out of view
      else if (sectionTop > windowHeight || sectionBottom < 0) {
        if (isAnimating) {
          resetCounters();
          isAnimating = false;
        }
      }
    }

    // Use Intersection Observer for better performance
    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          animateCounters();
        } else {
          // Reset when out of view
          setTimeout(() => {
            if (!entry.isIntersecting) {
              resetCounters();
              isAnimating = false;
            }
          }, 500);
        }
      });
    }, {
      threshold: 0.3,
      rootMargin: '-50px 0px -50px 0px'
    });

    observer.observe(document.getElementById('jandk-stats'));

    // Fallback scroll listener
    window.addEventListener('scroll', animateCounters);
