  document.addEventListener('DOMContentLoaded', function() {
            const serviceItems = document.querySelectorAll('.service-item');
            const serviceDisplays = document.querySelectorAll('.service-display');
            
            serviceItems.forEach(item => {
                item.addEventListener('click', function() {
                    const serviceType = this.getAttribute('data-service');
                    
                    // Remove active class from all items and displays
                    serviceItems.forEach(si => si.classList.remove('active'));
                    serviceDisplays.forEach(sd => sd.classList.remove('active'));
                    
                    // Add active class to clicked item
                    this.classList.add('active');
                    
                    // Show corresponding service display with slight delay for smooth transition
                    setTimeout(() => {
                        const targetDisplay = document.querySelector(`.service-display[data-service="${serviceType}"]`);
                        if (targetDisplay) {
                            targetDisplay.classList.add('active');
                        }
                    }, 100);
                });
            });
            
            // Smooth scroll behavior for view all link
            document.querySelector('.view-all a').addEventListener('click', function(e) {
                e.preventDefault();
                console.log('Navigate to all services page');
            });
        });